/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;

public abstract class ScalingPanel
extends JPanel {
    private JComboBox scalingComboBox;
    private TimerTextField valueTextField;
    private static final List<ChartGrid.ScalingMode> Y_AXIS_SCALING_MODES = Arrays.asList(ChartGrid.ScalingMode.CUSTOM, ChartGrid.ScalingMode.GLOBAL, ChartGrid.ScalingMode.ROW);

    public ScalingPanel(boolean isMin, ChartGrid.ScalingMode mode, float initialCustomValue) {
        final List<ChartGrid.ScalingMode> modes = Y_AXIS_SCALING_MODES;
        FormLayout fl = new FormLayout("p, 2px, p", "p");
        this.setLayout((LayoutManager)fl);
        this.scalingComboBox = UIUtil.createComboBox(new String[]{"Custom", "Global", "Row"});
        fl.setHonorsVisibility(false);
        this.scalingComboBox.setSelectedIndex(modes.indexOf((Object)mode));
        this.scalingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = ScalingPanel.this.scalingComboBox.getSelectedIndex();
                ScalingPanel.this.valueTextField.setVisible(selectedIndex == 0);
                ScalingPanel.this.setScalingMode((ChartGrid.ScalingMode)((Object)modes.get(selectedIndex)));
                if (selectedIndex == 0) {
                    ScalingPanel.this.parseText();
                }
            }
        });
        this.valueTextField = new TimerTextField(Float.isNaN(initialCustomValue) ? "" : Formatter.format(initialCustomValue)){

            @Override
            public void update() {
                ScalingPanel.this.parseText();
            }
        };
        this.valueTextField.setVisible(false);
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.scalingComboBox, cc.xy(1, 1));
        this.add((Component)this.valueTextField, cc.xy(3, 1));
    }

    protected abstract void setCustomValue(float var1);

    protected abstract void setScalingMode(ChartGrid.ScalingMode var1);

    private void parseText() {
        try {
            String text = this.valueTextField.getText().trim();
            float val = text.equals("") ? Float.NaN : ParserHelper.parseFloat(text);
            this.setCustomValue(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

