/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.cc;

import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSampler;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.clustering.cc.ClusteringAlgorithm;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.HCLClusterHelper;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Euclidean;
import org.broadinstitute.genee.clustering.kmeans.KMeansClusterer;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class CC {
    private ClusteringAlgorithm clusterer = new KMeansClusterer();
    private Dataset dataset;
    private List<Dendrogram> dendrograms;
    private int[] intSelection;
    private long[] longSelection;
    private int[] numberOfClustersArray = new int[]{2, 3, 4, 5};
    private MersenneTwister random;
    private int resamplingIterations = 20;
    private List<Dataset> resultDatasets;
    private int seed;
    private float subSampleRatio = 0.8f;
    private int subSampleSize;

    public void execute() {
        this.random = new MersenneTwister(this.seed);
        this.subSampleSize = (int)(this.subSampleRatio * (float)this.dataset.getRowCount());
        this.longSelection = new long[this.subSampleSize];
        this.intSelection = new int[this.subSampleSize];
        this.resultDatasets = new ArrayList<Dataset>();
        this.dendrograms = new ArrayList<Dendrogram>();
        int[][] chosen = this.createArray();
        int[][][] clusteredTogether = new int[this.numberOfClustersArray.length][][];
        int numClusters = this.numberOfClustersArray.length;
        for (int j = 0; j < numClusters; ++j) {
            clusteredTogether[j] = this.createArray();
        }
        for (int i = 0; i < this.resamplingIterations; ++i) {
            this.resample();
            this.addIndices(this.intSelection, chosen);
            this.clusterer.setDataset(DatasetUtil.sliceView(this.dataset, this.intSelection, null));
            int numClusters2 = this.numberOfClustersArray.length;
            for (int n = 0; n < numClusters2; ++n) {
                int k = this.numberOfClustersArray[n];
                int[][] together = clusteredTogether[n];
                this.clusterer.setNumberOfClusters(k);
                this.clusterer.execute();
                for (int j = 0; j < k; ++j) {
                    int[] clusterIndices = this.clusterer.getIndices(j);
                    Arrays.sort(clusterIndices);
                    this.addIndices(clusterIndices, this.intSelection, together);
                }
            }
        }
        numClusters = this.numberOfClustersArray.length;
        for (int n = 0; n < numClusters; ++n) {
            int k = this.numberOfClustersArray[n];
            int[][] together = clusteredTogether[n];
            RowMajorArray2DDataset d = this.createConsensusMatrix(k, together, chosen);
            HCLClusterHelper hcl = new HCLClusterHelper(d, new Euclidean(), null, LinkageMethod.AVERAGE_LINKAGE, null, null, null);
            this.dendrograms.add(hcl.getRowDendrogram());
            this.resultDatasets.add(DatasetUtil.sliceView(d, hcl.getRowOrder(), hcl.getRowOrder()));
        }
    }

    public List<Dendrogram> getDendrograms() {
        return this.dendrograms;
    }

    public int[] getNumberOfClusters() {
        return this.numberOfClustersArray;
    }

    public List<Dataset> getResultDatasets() {
        return this.resultDatasets;
    }

    public void setClusterer(ClusteringAlgorithm clusterer) {
        this.clusterer = clusterer;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public void setNumberOfClusters(int[] numberOfClusters) {
        this.numberOfClustersArray = numberOfClusters;
    }

    public void setResamplingIterations(int resamplingIterations) {
        this.resamplingIterations = resamplingIterations;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setSubSampleRatio(float subSampleRatio) {
        this.subSampleRatio = subSampleRatio;
    }

    private void addIndices(int[] indices, int[] subset, int[][] array) {
        int n = indices.length;
        for (int i = 1; i < n; ++i) {
            int highIndex = subset[indices[i]];
            for (int j = 0; j < i; ++j) {
                int lowIndex = subset[indices[j]];
                int[] nArray = array[highIndex];
                int n2 = lowIndex;
                nArray[n2] = nArray[n2] + 1;
            }
        }
    }

    private void addIndices(int[] indices, int[][] array) {
        int n = indices.length;
        for (int i = 1; i < n; ++i) {
            int highIndex = indices[i];
            for (int j = 0; j < i; ++j) {
                int lowIndex = indices[j];
                int[] nArray = array[highIndex];
                int n2 = lowIndex;
                nArray[n2] = nArray[n2] + 1;
            }
        }
    }

    private int[][] createArray() {
        int[][] array = new int[this.dataset.getRowCount()][];
        int rows = this.dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            array[i] = new int[i];
        }
        return array;
    }

    private RowMajorArray2DDataset createConsensusMatrix(int k, int[][] together, int[][] chosen) {
        int i;
        RowMajorArray2DDataset d = new RowMajorArray2DDataset(k + " Clusters", this.dataset.getRowCount(), this.dataset.getRowCount());
        int n = d.getRowCount();
        for (i = 0; i < n; ++i) {
            d.setValue(i, i, 1.0f);
        }
        MetadataUtil.copy(this.dataset.getRowMetadata(), d.getRowMetadata());
        d.setColumnMetadata(d.getRowMetadata());
        for (i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                float value = (float)together[i][j] / (float)chosen[i][j];
                d.setValue(i, j, value);
                d.setValue(j, i, value);
            }
        }
        return d;
    }

    private void resample() {
        RandomSampler.sample((long)this.subSampleSize, (long)this.dataset.getRowCount(), (int)this.subSampleSize, (long)0L, (long[])this.longSelection, (int)0, (RandomElement)this.random);
        for (int j = 0; j < this.subSampleSize; ++j) {
            this.intSelection[j] = (int)this.longSelection[j];
        }
    }
}

