/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import com.google.common.base.Function;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.FloatList;

public class AtrGtrDendrogram
implements Dendrogram {
    private DistanceFunction distanceFunction;
    private Map<String, Integer> id2Index;
    private String[] ids;
    private Map<String, Node> leafNodes;
    private LinkageMethod linkageMethod;
    private float maxDistance = -3.4028235E38f;
    private float minDistance = Float.MAX_VALUE;
    private Node rootArrayNode;

    public AtrGtrDendrogram(String[] ids, DendrogramReader br, DistanceFunction distanceFunction, LinkageMethod linkageMethod) throws IOException {
        this(ids, br, 0, distanceFunction, linkageMethod);
    }

    public AtrGtrDendrogram(String[] ids, DendrogramReader br, int indexOffset, DistanceFunction distanceFunction, LinkageMethod linkageMethod) throws IOException {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException();
        }
        this.distanceFunction = distanceFunction;
        this.linkageMethod = linkageMethod;
        this.ids = ids;
        this.parse(br, ids, indexOffset);
    }

    public AtrGtrDendrogram(String[] ids, String pathname) throws IOException {
        this(ids, new BufferedReaderDendrogramReader(new BufferedReader(new InputStreamReader(IOUtil.getInputStream(pathname)), 0x100000)), 0, null, null);
    }

    @Override
    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    @Override
    public String[] getLeafNodeIds() {
        return this.ids;
    }

    @Override
    public Map<String, Node> getLeafNodes() {
        return this.leafNodes;
    }

    @Override
    public LinkageMethod getLinkageMethod() {
        return this.linkageMethod;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public float getMinDistance() {
        return this.minDistance;
    }

    @Override
    public Node[] getRootNodes() {
        return new Node[]{this.rootArrayNode};
    }

    @Override
    public void save(OutputStream os, String format) {
        PrintWriter pw = new PrintWriter(os);
        this.writeAtrGtr(pw);
        pw.flush();
    }

    public void writeAtrGtr(PrintWriter pw) {
        Node[] rootNodesArray = this.getRootNodes();
        if (rootNodesArray.length > 1) {
            throw new UnsupportedOperationException();
        }
        Node root = rootNodesArray[0];
        final ArrayList nodes = new ArrayList();
        AtrGtrDendrogram.traverse(root, new Function<Node, Void>(){

            public Void apply(Node n) {
                nodes.add(n);
                return null;
            }
        });
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                int num2;
                int num1 = AtrGtrDendrogram.getNumber(o1);
                if (num1 < (num2 = AtrGtrDendrogram.getNumber(o2))) {
                    return -1;
                }
                if (num1 > num2) {
                    return 1;
                }
                return 0;
            }
        });
        int length = nodes.size();
        for (int i = 0; i < length; ++i) {
            Node node = (Node)nodes.get(i);
            pw.print(node.getId());
            pw.print("\t");
            pw.print(node.getLeft().getId());
            pw.print("\t");
            pw.print(node.getRight().getId());
            pw.print("\t");
            pw.println(Formatter.format(node.getDistance()));
        }
        pw.flush();
    }

    void parse(DendrogramReader reader, String[] ids, int indexOffset) throws IOException {
        Node node = null;
        this.id2Index = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < ids.length; ++i) {
            this.id2Index.put(ids[i], i + indexOffset);
        }
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        boolean isFirst = true;
        boolean isSecond = false;
        boolean convertToDistances = false;
        while (reader.next()) {
            Node rnode;
            int index;
            Node lnode;
            String left = reader.left();
            String right = reader.right();
            String id = reader.id();
            float distance = reader.distance();
            if (isFirst) {
                isFirst = false;
                isSecond = true;
                this.minDistance = distance;
            } else if (isSecond) {
                if (distance > this.minDistance) {
                    convertToDistances = false;
                    isSecond = false;
                } else if (distance < this.minDistance) {
                    convertToDistances = true;
                    isSecond = false;
                }
            }
            Color color = reader.color();
            if (nodes.containsKey(left)) {
                lnode = (Node)nodes.get(left);
            } else {
                lnode = new Node(left);
                index = this.getIndex(left);
                lnode.setIndex(index);
                lnode.setMinIndex(index);
                lnode.setMaxIndex(index);
                nodes.put(left, lnode);
            }
            if (nodes.containsKey(right)) {
                rnode = (Node)nodes.get(right);
            } else {
                rnode = new Node(right);
                index = this.getIndex(right);
                rnode.setIndex(index);
                rnode.setMinIndex(index);
                rnode.setMaxIndex(index);
                nodes.put(right, rnode);
            }
            node = new Node(id, lnode, rnode, distance);
            if (color != null) {
                node.setColor(color);
                node.setRootColor(color);
            }
            node.setMinIndex(Math.min(rnode.getMinIndex(), lnode.getMinIndex()));
            node.setMaxIndex(Math.max(rnode.getMaxIndex(), lnode.getMaxIndex()));
            lnode.setParent(node);
            rnode.setParent(node);
            nodes.put(id, node);
        }
        if (node == null) {
            throw new IOException("No dendrogram root found.");
        }
        this.maxDistance = node.getDistance();
        if (convertToDistances) {
            final float maxSimilarity = this.minDistance;
            AtrGtrDendrogram.traverse(node, new Function<Node, Void>(){

                public Void apply(Node n) {
                    n.setDistance(maxSimilarity - n.getDistance());
                    return null;
                }
            });
            float tmp = this.maxDistance = this.minDistance - this.maxDistance;
            this.maxDistance = this.minDistance;
            this.minDistance = tmp;
        }
        this.minDistance = 0.0f;
        this.leafNodes = new HashMap<String, Node>();
        for (String leaf : ids) {
            this.leafNodes.put(leaf, (Node)nodes.get(leaf));
        }
        this.rootArrayNode = node;
    }

    private static void traverse(Node node, Function<Node, Void> nodeFunction) {
        Node left = node.getLeft();
        Node right = node.getRight();
        nodeFunction.apply((Object)node);
        if (!left.isLeaf()) {
            AtrGtrDendrogram.traverse(left, nodeFunction);
        }
        if (!right.isLeaf()) {
            AtrGtrDendrogram.traverse(right, nodeFunction);
        }
    }

    private int getIndex(String id) throws IOException {
        Integer index = this.id2Index.get(id);
        if (index == null) {
            throw new IOException("id " + id + " not found");
        }
        return index;
    }

    private static int getNumber(Node node) {
        String id = node.getId();
        return Integer.parseInt(id.substring("NODE".length(), id.length() - 1));
    }

    public static interface DendrogramReader {
        public Color color();

        public float distance();

        public String id();

        public String left();

        public boolean next() throws IOException;

        public String right();
    }

    public static class BufferedReaderDendrogramReader
    implements DendrogramReader {
        private BufferedReader br;
        private Color color;
        private float distance;
        private String id;
        private String left;
        private String line;
        private String right;

        public BufferedReaderDendrogramReader(BufferedReader br) {
            this.br = br;
        }

        @Override
        public Color color() {
            return this.color;
        }

        @Override
        public float distance() {
            return this.distance;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String left() {
            return this.left;
        }

        @Override
        public boolean next() throws IOException {
            this.line = this.br.readLine();
            if (this.line != null) {
                StringTokenizer tokens = new StringTokenizer(this.line, "\t");
                this.id = tokens.nextToken();
                this.left = tokens.nextToken();
                this.right = tokens.nextToken();
                String t = tokens.nextToken();
                this.distance = 0.0f;
                try {
                    this.distance = ParserHelper.parseFloat(t);
                }
                catch (NumberFormatException e) {
                    throw new IOException(t + " is not a number.");
                }
                this.color = null;
                if (tokens.hasMoreTokens()) {
                    String c = tokens.nextToken();
                    try {
                        this.color = ImageUtil.decodeColor(c);
                    }
                    catch (Throwable x) {
                        System.err.println("Error parsing color " + c + ".");
                    }
                }
                return true;
            }
            this.br.close();
            return false;
        }

        @Override
        public String right() {
            return this.right;
        }
    }

    public static class ArrayDendrogramReader
    implements DendrogramReader {
        private FloatList distances;
        private String[] ids;
        private String[] left;
        private String[] right;
        private int index = -1;

        public ArrayDendrogramReader(String[] ids, String[] left, String[] right, FloatList distances) {
            this.ids = ids;
            this.left = left;
            this.right = right;
            this.distances = distances;
        }

        @Override
        public Color color() {
            return null;
        }

        @Override
        public float distance() {
            return this.distances.getValue(this.index);
        }

        @Override
        public String id() {
            return this.ids[this.index];
        }

        @Override
        public String left() {
            return this.left[this.index];
        }

        @Override
        public boolean next() throws IOException {
            ++this.index;
            return this.index < this.left.length;
        }

        @Override
        public String right() {
            return this.right[this.index];
        }
    }
}

