/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;

public class DendrogramList
implements Dendrogram {
    private DistanceFunction distanceFunction;
    private boolean isDistance;
    private List<String> leafNodeIds;
    private Map<String, Node> leafNodes;
    private LinkageMethod linkageMethod;
    private float maxCorr = -3.4028235E38f;
    private float minCorr = Float.MAX_VALUE;
    private List<Node> rootNodes;

    public DendrogramList(DistanceFunction distanceFunction, LinkageMethod linkageMethod) {
        this.distanceFunction = distanceFunction;
        this.linkageMethod = linkageMethod;
        this.leafNodeIds = new ArrayList<String>();
        this.leafNodes = new HashMap<String, Node>();
        this.rootNodes = new ArrayList<Node>();
    }

    public void add(Dendrogram d) {
        Node[] roots;
        for (Node root : roots = d.getRootNodes()) {
            this.rootNodes.add(root);
        }
        this.minCorr = Math.min(this.minCorr, d.getMinDistance());
        this.maxCorr = Math.max(this.maxCorr, d.getMaxDistance());
        this.leafNodes.putAll(d.getLeafNodes());
        this.leafNodeIds.addAll(Arrays.asList(d.getLeafNodeIds()));
    }

    public void addRoot(Node node) {
        this.rootNodes.add(node);
        this.leafNodes.put(node.getId(), node);
        this.leafNodeIds.add(node.getId());
    }

    @Override
    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    @Override
    public String[] getLeafNodeIds() {
        return this.leafNodeIds.toArray(new String[0]);
    }

    @Override
    public Map<String, Node> getLeafNodes() {
        return this.leafNodes;
    }

    @Override
    public LinkageMethod getLinkageMethod() {
        return this.linkageMethod;
    }

    @Override
    public float getMaxDistance() {
        return this.maxCorr;
    }

    @Override
    public float getMinDistance() {
        return this.minCorr;
    }

    @Override
    public Node[] getRootNodes() {
        return this.rootNodes.toArray(new Node[0]);
    }

    @Override
    public void save(OutputStream os, String format) {
        throw new UnsupportedOperationException("Unable to save multi-dendrograms.");
    }
}

