/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class DendrogramSearchAction
extends AbstractAction {
    protected List<Node> searchResults;
    private HeatMapPanel heatMapPanel;
    private Project project;
    private boolean row;
    private TimerTextField textField;
    private GENEEWindow window;

    public DendrogramSearchAction(HeatMapPanel heatMapPanel, boolean row) {
        super("Search " + (row ? "Row" : "Column") + " Dendrogram" + "\u2026");
        this.row = row;
        this.heatMapPanel = heatMapPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        if (this.window == null) {
            this.init();
        }
        this.window.setVisible(true);
        this.textField.grabFocus();
    }

    private void _findNodes(Node node, List<Node> results, LuceneSearchParser.IndexedSearchPredicate filter) {
        Node left = node.getLeft();
        Node right = node.getRight();
        String id = node.getId();
        filter.setData(node);
        boolean filtered = !filter.accept(0);
        node.setHighlighted(!filtered);
        if (!filtered) {
            results.add(node);
        }
        if (!left.isLeaf()) {
            this._findNodes(left, results, filter);
        }
        if (!right.isLeaf()) {
            this._findNodes(right, results, filter);
        }
    }

    private List<Node> findNodes(Dendrogram dendrogram, String searchString) {
        Node[] rootNodes;
        ArrayList<Node> results = new ArrayList<Node>();
        LuceneSearchParser.IndexedSearchPredicate filter = LuceneSearchParser.parse(new MySearchPredicateAdapterCreator(), searchString, false, true, 0, "");
        for (Node root : rootNodes = dendrogram.getRootNodes()) {
            this._findNodes(root, results, filter);
        }
        return results;
    }

    private void init() {
        this.window = Application.createDialog("Search " + (this.row ? "Row" : "Column") + " Dendrogram", new GENEEWindowNotifier(){

            @Override
            public void notifyHidden() {
                if (DendrogramSearchAction.this.searchResults != null) {
                    for (Node node : DendrogramSearchAction.this.searchResults) {
                        node.setHighlighted(false);
                    }
                }
                if (DendrogramSearchAction.this.row) {
                    DendrogramSearchAction.this.project.setHighlightedRowDendrogramNodes(null);
                    DendrogramSearchAction.this.heatMapPanel.getRowDendrogramPanel().repaintImage();
                } else {
                    DendrogramSearchAction.this.project.setHighlightedColumnDendrogramNodes(null);
                    DendrogramSearchAction.this.heatMapPanel.getColumnDendrogramPanel().repaintImage();
                }
            }

            @Override
            public void notifyShowing() {
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.setIndentedBorder();
        formBuilder.nextRow();
        formBuilder.addLabel("Search nodes for:");
        this.textField = new TimerTextField(){

            @Override
            public void update() {
                DendrogramSearchAction.this.project = Application.getProject();
                Dendrogram dendrogram = DendrogramSearchAction.this.row ? DendrogramSearchAction.this.project.getRowDendrogram() : DendrogramSearchAction.this.project.getColumnDendrogram();
                String text = this.getText();
                if (text != null && !(text = text.trim()).equals("")) {
                    DendrogramSearchAction.this.searchResults = DendrogramSearchAction.this.findNodes(dendrogram, text);
                } else {
                    if (DendrogramSearchAction.this.searchResults != null) {
                        for (Node node : DendrogramSearchAction.this.searchResults) {
                            node.setHighlighted(false);
                        }
                    }
                    DendrogramSearchAction.this.searchResults = null;
                }
                Comparator<Node> c = new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        return Float.compare(o1.index, o2.index);
                    }
                };
                if (DendrogramSearchAction.this.searchResults != null) {
                    Collections.sort(DendrogramSearchAction.this.searchResults, c);
                }
                if (DendrogramSearchAction.this.row) {
                    DendrogramSearchAction.this.project.setHighlightedRowDendrogramNodes(DendrogramSearchAction.this.searchResults);
                    DendrogramSearchAction.this.heatMapPanel.getRowDendrogramPanel().repaintImage();
                } else {
                    DendrogramSearchAction.this.project.setHighlightedColumnDendrogramNodes(DendrogramSearchAction.this.searchResults);
                    DendrogramSearchAction.this.heatMapPanel.getColumnDendrogramPanel().repaintImage();
                }
            }
        };
        formBuilder.add(this.textField);
        this.window.getContentPane().add(formBuilder.getPanel());
        this.window.pack();
    }

    private static class MySearchPredicateAdapterCreator
    implements LuceneSearchParser.SearchPredicateAdapterCreator {
        private MySearchPredicateAdapterCreator() {
        }

        @Override
        public LuceneSearchParser.IndexedSearchPredicate create(final LuceneSearchParser.InternalSearchPredicate internalSearchPredicate) {
            return new LuceneSearchParser.IndexedSearchPredicate(){
                private Node node;

                @Override
                public boolean accept(int index) {
                    return internalSearchPredicate.accept(this.node.getId());
                }

                @Override
                public void setData(Object data) {
                    this.node = (Node)data;
                }
            };
        }
    }
}

