/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import org.broadinstitute.genee.clustering.hierarchical.AtrGtrDendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.GroupBy;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.HCLCluster;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;

public class HCLClusterHelper {
    private Dendrogram columnDendrogram = null;
    private int[] columnIndices = null;
    private Dataset dataset;
    private Dendrogram rowDendrogram = null;
    private int[] rowIndices = null;
    private Map<Identifier, TIntArrayList> groupByToRowIndices;
    private Map<Identifier, TIntArrayList> groupByToColumnIndices;

    public HCLClusterHelper(Dataset dataset, DistanceFunction rowMetric, String[] groupRowsBy, LinkageMethod rowLinkageMethod, DistanceFunction columnMetric, String[] groupColumnsBy, LinkageMethod columnLinkageMethod) {
        this(dataset, null, null, rowMetric, false, groupRowsBy, rowLinkageMethod, columnMetric, false, groupColumnsBy, columnLinkageMethod);
    }

    public HCLClusterHelper(Dataset dataset, float[][] rowDistanceMatrix, float[][] columnDistanceMatrix, DistanceFunction rowMetric, boolean scaleRowDistanceToOne, String[] groupRowsBy, LinkageMethod rowLinkageMethod, DistanceFunction columnMetric, boolean scaleColumnDistanceToOne, String[] groupColumnsBy, LinkageMethod columnLinkageMethod) {
        BufferedReader br;
        HCLCluster hcl;
        this.dataset = dataset;
        if (groupRowsBy != null && rowMetric != null) {
            GroupBy groupRowsObject = new GroupBy(dataset, groupRowsBy, rowMetric, rowLinkageMethod);
            this.rowDendrogram = groupRowsObject.groupByDendrogram;
            this.rowIndices = groupRowsObject.reorderedIndices;
            this.groupByToRowIndices = groupRowsObject.groupByToRowIndices;
        } else if (rowLinkageMethod != null) {
            hcl = new HCLCluster(rowDistanceMatrix != null ? rowDistanceMatrix : HCLCluster.computeDistanceMatrix(dataset, rowMetric), rowLinkageMethod, rowMetric, scaleRowDistanceToOne);
            this.rowIndices = hcl.getIndices();
            StringWriter gtrWriter = new StringWriter();
            hcl.writeAtrGtr(new PrintWriter(gtrWriter));
            gtrWriter.flush();
            br = new BufferedReader(new StringReader(gtrWriter.getBuffer().toString()));
            try {
                this.rowDendrogram = new AtrGtrDendrogram(hcl.getReorderedIds(), new AtrGtrDendrogram.BufferedReaderDendrogramReader(br), 0, hcl.getDistanceFunction(), rowLinkageMethod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (groupColumnsBy != null && columnMetric != null) {
            GroupBy groupColumnsObject = new GroupBy(DatasetUtil.transposeView(dataset), groupColumnsBy, columnMetric, columnLinkageMethod);
            this.columnDendrogram = groupColumnsObject.groupByDendrogram;
            this.columnIndices = groupColumnsObject.reorderedIndices;
            this.groupByToColumnIndices = groupColumnsObject.groupByToRowIndices;
        } else if (columnLinkageMethod != null) {
            hcl = new HCLCluster(columnDistanceMatrix != null ? columnDistanceMatrix : HCLCluster.computeDistanceMatrix(DatasetUtil.transposeView(dataset), columnMetric), columnLinkageMethod, columnMetric, scaleColumnDistanceToOne);
            this.columnIndices = hcl.getIndices();
            StringWriter atrWriter = new StringWriter();
            hcl.writeAtrGtr(new PrintWriter(atrWriter));
            atrWriter.flush();
            br = new BufferedReader(new StringReader(atrWriter.getBuffer().toString()));
            try {
                this.columnDendrogram = new AtrGtrDendrogram(hcl.getReorderedIds(), new AtrGtrDendrogram.BufferedReaderDendrogramReader(br), 0, hcl.getDistanceFunction(), columnLinkageMethod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int[] getColumnOrder() {
        return this.columnIndices;
    }

    public Project getProject() {
        return new DefaultProject(DatasetUtil.sliceView(this.dataset, this.rowIndices, this.columnIndices), this.rowDendrogram, this.columnDendrogram, null);
    }

    public int[] getRowOrder() {
        return this.rowIndices;
    }

    public Dendrogram getRowDendrogram() {
        return this.rowDendrogram;
    }

    public Dendrogram getColumnDendrogram() {
        return this.columnDendrogram;
    }

    public Map<Identifier, TIntArrayList> getGroupByToRowIndices() {
        return this.groupByToRowIndices;
    }

    public Map<Identifier, TIntArrayList> getGroupByToColumnIndices() {
        return this.groupByToColumnIndices;
    }
}

