/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.ClosestPairResult;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.HCLCluster;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.Node;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.linkage.LinkageAlgorithm;

public class CompleteLinkage
implements LinkageAlgorithm {
    @Override
    public Node[] cluster(int nelements, float[][] distmatrix) {
        int j;
        int[] clusterid = new int[nelements];
        Node[] result = new Node[nelements - 1];
        for (int i = 0; i < nelements - 1; ++i) {
            result[i] = new Node();
        }
        for (j = 0; j < nelements; ++j) {
            clusterid[j] = j;
        }
        ClosestPairResult r = new ClosestPairResult();
        for (int n = nelements; n > 1; --n) {
            HCLCluster.find_closest_pair(n, distmatrix, r);
            result[nelements - n].distance = r.distance;
            int is = r.ip;
            int js = r.jp;
            for (j = 0; j < js; ++j) {
                distmatrix[js][j] = Math.max(distmatrix[is][j], distmatrix[js][j]);
            }
            for (j = js + 1; j < is; ++j) {
                distmatrix[j][js] = Math.max(distmatrix[is][j], distmatrix[j][js]);
            }
            for (j = is + 1; j < n; ++j) {
                distmatrix[j][js] = Math.max(distmatrix[j][is], distmatrix[j][js]);
            }
            for (j = 0; j < is; ++j) {
                distmatrix[is][j] = distmatrix[n - 1][j];
            }
            for (j = is + 1; j < n - 1; ++j) {
                distmatrix[j][is] = distmatrix[n - 1][j];
            }
            result[nelements - n].left = clusterid[is];
            result[nelements - n].right = clusterid[js];
            clusterid[js] = n - nelements - 1;
            clusterid[is] = clusterid[n - 1];
        }
        return result;
    }
}

