/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class JaccardDistanceFunction
implements DistanceFunction {
    @Override
    public float evaluate(Dataset dataset, float[] weight, int index1, int index2) {
        float orCount = 0.0f;
        float andCount = 0.0f;
        int size = dataset.getColumnCount();
        for (int i = 0; i < size; ++i) {
            boolean y;
            boolean x = dataset.getValue(index1, i) > 0.0f;
            boolean bl = y = dataset.getValue(index2, i) > 0.0f;
            if (x && y) {
                andCount += 1.0f;
                continue;
            }
            if (!x && !y) continue;
            orCount += 1.0f;
        }
        return (orCount - andCount) / orCount;
    }

    public String toString() {
        return "Jaccard distance";
    }
}

