/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.stats.Sorting;

public class SpearmanV1
implements DistanceFunction {
    @Override
    public float evaluate(Dataset dataset, float[] weights, int index1, int index2) {
        int i;
        float result = 0.0f;
        float denom1 = 0.0f;
        float denom2 = 0.0f;
        int n = dataset.getColumnCount();
        TFloatArrayList tdata1 = new TFloatArrayList();
        TFloatArrayList tdata2 = new TFloatArrayList();
        for (i = 0; i < n; ++i) {
            float term1 = dataset.getValue(index1, i);
            float term2 = dataset.getValue(index2, i);
            if (Float.isNaN(term1) || Float.isNaN(term2)) continue;
            tdata1.add(term1);
            tdata2.add(term2);
        }
        float[] rank1 = SpearmanV1.getrank(tdata1);
        float[] rank2 = SpearmanV1.getrank(tdata2);
        int m = tdata1.size();
        float avgrank = 0.5f * (float)(m - 1);
        for (i = 0; i < m; ++i) {
            float value1 = rank1[i];
            float value2 = rank2[i];
            result += value1 * value2;
            denom1 += value1 * value1;
            denom2 += value2 * value2;
        }
        result /= (float)m;
        denom1 /= (float)m;
        denom2 /= (float)m;
        result -= avgrank * avgrank;
        denom1 -= avgrank * avgrank;
        denom2 -= avgrank * avgrank;
        if (denom1 <= 0.0f) {
            return 1.0f;
        }
        if (denom2 <= 0.0f) {
            return 1.0f;
        }
        result = (float)((double)result / Math.sqrt(denom1 * denom2));
        result = 1.0f - result;
        return result;
    }

    public static float[] getrank(TFloatArrayList data) {
        int m;
        int i;
        int n = data.size();
        float[] rank = new float[n];
        int[] index = Sorting.index(data, true);
        for (i = 0; i < n; ++i) {
            rank[index[i]] = i;
        }
        for (i = 0; i < n; i += m) {
            int j;
            float value = data.getQuick(index[i]);
            for (j = i + 1; j < n && data.getQuick(index[j]) == value; ++j) {
            }
            m = j - i;
            value = rank[index[i]] + (float)(m - 1) / 2.0f;
            for (j = i; j < i + m; ++j) {
                rank[index[j]] = value;
            }
        }
        return rank;
    }

    public String toString() {
        return "One minus spearman's rank correlation (version 1)";
    }
}

