/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.clustering.nmf;

import org.broadinstitute.genee.clustering.cc.AbstractMevClusterer;
import org.broadinstitute.genee.heatmap.Project;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.util.FloatMatrix;

public class MevNMFClusterer
extends AbstractMevClusterer {
    Project[] connectivityMatrix;
    FloatMatrix[][] W;
    FloatMatrix[][] H;
    float[][] costs;
    int[][][] clusters;
    FloatMatrix[] means;
    FloatMatrix[] variances;
    float[] cophen;
    private int numRuns = 10;
    private int randomSeed;
    private boolean adjustData;
    private float cutoff = 1.0f;
    private boolean doMax = true;
    private boolean expScale = false;
    private int maxIters = 1000;
    private final boolean doSamples = false;
    private int checkFreq = 40;
    private boolean divergence = true;
    private int maxrvalue = 4;

    @Override
    public void execute() {
        int rvalue;
        AlgorithmData data = new AlgorithmData();
        this.maxrvalue = rvalue = this.k;
        int numFactorRuns = 1 + this.maxrvalue - rvalue;
        this.connectivityMatrix = new Project[numFactorRuns];
        this.W = new FloatMatrix[numFactorRuns][];
        System.out.println("k " + numFactorRuns);
        this.H = new FloatMatrix[numFactorRuns][];
        this.costs = new float[numFactorRuns][];
        this.clusters = new int[numFactorRuns][][];
        this.means = new FloatMatrix[numFactorRuns];
        this.variances = new FloatMatrix[numFactorRuns];
        this.cophen = new float[numFactorRuns];
        data.addMatrix("experiment", this.matrix);
        data.addParam("r-value", String.valueOf(rvalue));
        data.addParam("min- r-value", String.valueOf(rvalue));
        data.addParam("max- r-value", String.valueOf(this.maxrvalue));
        data.addParam("runs", String.valueOf(this.numRuns));
        data.addParam("iterations", String.valueOf(this.maxIters));
        data.addParam("checkFreq", String.valueOf(this.checkFreq));
        data.addParam("divergence", String.valueOf(this.divergence));
        data.addParam("doSamples", String.valueOf(false));
        data.addParam("expScale", String.valueOf(this.expScale));
        data.addParam("doMax", String.valueOf(this.doMax));
        data.addParam("cutoff", String.valueOf(this.cutoff));
        data.addParam("adjustData", String.valueOf(this.adjustData));
        data.addParam("multiClusters", String.valueOf(false));
        data.addParam("randomSeed", String.valueOf(this.randomSeed));
        long start = System.currentTimeMillis();
        data.addParam("startTime", String.valueOf(start));
        Cluster[] result_cluster = new Cluster[1 + this.maxrvalue - rvalue];
        for (int factorIndex = 0; factorIndex <= this.maxrvalue - rvalue; ++factorIndex) {
            int i;
            data.addParam("r-value", String.valueOf(rvalue + factorIndex));
            AlgorithmData result = null;
            result_cluster[factorIndex] = result.getCluster("cluster");
            this.clusters[factorIndex] = result.getIntMatrix("clusters");
            this.means[factorIndex] = result.getMatrix("clusters_means");
            this.variances[factorIndex] = result.getMatrix("clusters_variances");
            this.cophen[factorIndex] = result.getParams().getFloat("cophen");
            this.W[factorIndex] = new FloatMatrix[this.numRuns];
            this.H[factorIndex] = new FloatMatrix[this.numRuns];
            for (i = 0; i < this.numRuns; ++i) {
                this.W[factorIndex][i] = result.getMatrix("W" + i);
            }
            for (i = 0; i < this.numRuns; ++i) {
                this.H[factorIndex][i] = result.getMatrix("H" + i);
            }
            this.costs[factorIndex] = result.getMatrix((String)"costs").transpose().A[0];
            this.adjustData = result.getParams().getBoolean("adjustData");
        }
    }

    @Override
    public int[] getIndices(int clusterIndex) {
        return this.clusters[0][clusterIndex];
    }
}

