/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.gui.AbstractGenericInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.gui.parameters.TextAreaParameter;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;

public class BarcodeGeneratorAction
extends AbstractGenericInputAction<Void> {
    private static final String ADD_ORDER_PREFIX = "Add order prefix";
    private static final String BARCODE_OUTPUT_DIRECTORY = "Barcode output directory";
    private static final String ENTER_BARCODES = "Barcodes";
    private static final String BARCODE_WIDTH = "Barcode width (inches)";
    private static final String BARCODE_HEIGHT = "Barcode  height (inches)";

    public BarcodeGeneratorAction() {
        super("Barcode Generator");
        this.addParameter(ENTER_BARCODES, new TextAreaParameter(), true);
        this.addParameter(ADD_ORDER_PREFIX, new CheckBoxParameter(), false);
        this.addParameter(BARCODE_OUTPUT_DIRECTORY, new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY), false);
    }

    @Override
    protected Void execute(Map<String, Object> inputMap, ProgressNotifier status) throws Exception {
        File directory = ((File[])inputMap.get(BARCODE_OUTPUT_DIRECTORY))[0];
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String text = (String)inputMap.get(ENTER_BARCODES);
        String[] barcodes = text.split("\n");
        boolean addPrefix = (Boolean)inputMap.get(ADD_ORDER_PREFIX);
        int numDigits = (int)(Math.floor(LogScaleUnivariateFunction.log10(barcodes.length)) + 1.0);
        System.out.println(numDigits);
        for (int i = 0; i < barcodes.length; ++i) {
            String code = barcodes[i];
            if ((code = code.trim()).length() <= 0) continue;
            int iPlus1 = i + 1;
            StringBuilder name = new StringBuilder();
            if (addPrefix) {
                name.append(iPlus1);
                while (name.length() < numDigits) {
                    name.insert(0, "0");
                }
                name.append("_");
            }
            name.append(URLEncoder.encode(code, "UTF-8"));
            BarcodeGeneratorAction.generateBarcode(directory, code, name.toString(), -1.0f, -1.0f);
        }
        return null;
    }

    @Override
    protected void succeeded(Map<String, Object> map, MutableTreeNode parentNode, Void result) {
    }

    private static void generateBarcode(File directory, String unencodedCode, String fileName, float barCodeWidthInches, float BarCodeHeightInches) {
        try {
            String encodedCode = URLEncoder.encode(unencodedCode, "UTF-8");
            float dotsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
            URL url = new URL("http://www.morovia.com/free-online-barcode-generator/barcode.asp?Symbology=5&BarHeight=150&ShowHRText=1&NarrowBarWidth=10&Message=" + encodedCode + "&Rotation=0");
            BufferedImage image = ImageIO.read(url);
            if (image == null) {
                throw new RuntimeException("Unable to create barcode for " + unencodedCode + ".");
            }
            float w = (float)image.getWidth() / dotsPerInch;
            float h = (float)image.getHeight() / dotsPerInch;
            int pw = (int)Math.floor(barCodeWidthInches * dotsPerInch);
            int ph = (int)Math.floor(BarCodeHeightInches * dotsPerInch);
            if (fileName == null) {
                fileName = encodedCode;
            }
            File file = new File(directory, fileName + ".png");
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to create barcode for " + unencodedCode + ".");
        }
    }
}

