/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import java.io.File;
import java.io.FileFilter;

public class L1000Util {
    public static final String PLATE_DIR = System.getProperty("plate.dir") != null ? System.getProperty("plate.dir") : "/xchip/cogs/data/plates/processed";
    public static final String BREW_DIR = System.getProperty("brew.dir") != null ? System.getProperty("brew.dir") : "/xchip/cogs/data/brew";

    private L1000Util() {
    }

    public static int getColumnCount(String filename) {
        String s = filename.substring(filename.lastIndexOf(110) + 1, filename.lastIndexOf(120));
        return Integer.parseInt(s);
    }

    public static File getGctFile(DataFile dataFileType, File dir, boolean isPlateDir) {
        String text;
        File[] gct;
        String s = dataFileType.toString();
        if (isPlateDir && s.startsWith("ZS")) {
            dir = new File(dir, "zs");
        }
        if (dir.exists() && (gct = dir.listFiles(new FileFilter(text = dataFileType.text){
            final /* synthetic */ String val$text;
            {
                this.val$text = string;
            }

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return (name.endsWith(".gct") || name.endsWith(".gctx")) && name.contains(this.val$text);
            }
        })).length == 1) {
            return gct[0];
        }
        return null;
    }

    public static File getPlateDir(String plateName) {
        File[] secondLevelDirs;
        File topLevelDir = new File(PLATE_DIR);
        if (!topLevelDir.exists()) {
            return null;
        }
        for (File secondLevelDir : secondLevelDirs = topLevelDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            File[] plateDirs;
            for (File plateDir : plateDirs = secondLevelDir.listFiles()) {
                if (!plateDir.getName().equals(plateName)) continue;
                return plateDir;
            }
        }
        return null;
    }

    public static int getRowCount(String filename) {
        String s = filename.substring(filename.lastIndexOf(120) + 1, filename.lastIndexOf(46));
        return Integer.parseInt(s);
    }

    public static enum DataFile {
        GEX("_GEX_"),
        INF("_INF_"),
        NORM("_NORM_"),
        QNORM("_QNORM_"),
        ZSQNORM("_ZSQNORM_"),
        ZSINF("_ZSINF_"),
        COMPZ_MODZ_RANK("_COMPZ.MODZ_RANK_"),
        COMPZ_MODZ_SCORE("_COMPZ.MODZ_SCORE_n");

        private String text;

        private DataFile(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

