/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.broadinstitute.genee.io.util.PlateUtil;

public class ListToPlate {
    private Sheet sheet;
    private Workbook wb = new HSSFWorkbook();

    public ListToPlate(File xlsFile, Map<String, String> wellToValue) throws IOException {
        this.sheet = this.wb.createSheet("Sheet1");
        this.createPlateColumnHeader(0);
        for (int i = 0; i < 16; ++i) {
            int[] columns;
            char c = PlateUtil.convertRowIndexToChar(i);
            Row row = this.sheet.createRow(i + 1);
            for (int col : columns = new int[]{0, 25}) {
                Cell cell = row.createCell(col);
                cell.setCellValue("" + c);
                cell.setCellStyle(this.getHeaderStyle());
            }
        }
        this.createPlateColumnHeader(17);
        short[] colors = new short[]{10, 12, 53, 13, 17, 29, 20, 47, 22, 62};
        HashSet<String> values = new HashSet<String>(wellToValue.values());
        HashMap<String, Short> valueToColor = new HashMap<String, Short>();
        int colorIndex = 0;
        for (String value : values) {
            short c = colors[colorIndex % colors.length];
            valueToColor.put(value, c);
            ++colorIndex;
        }
        for (String well : wellToValue.keySet()) {
            String value = wellToValue.get(well);
            String letter = String.valueOf(well.charAt(0));
            int rowIndex = PlateUtil.convertWellRowToInt(letter);
            String columnString = well.substring(1);
            if (columnString.charAt(0) == '0') {
                columnString.substring(1);
            }
            int colIndex = Integer.parseInt(columnString);
            CellStyle style = this.wb.createCellStyle();
            style.setFillForegroundColor(((Short)valueToColor.get(value)).shortValue());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            Row row = this.sheet.getRow(rowIndex + 1);
            Cell cell = row.createCell(colIndex);
            cell.setCellValue(value);
            cell.setCellStyle(style);
        }
        FileOutputStream fos = new FileOutputStream(xlsFile);
        this.wb.write((OutputStream)fos);
        fos.close();
    }

    private void createPlateColumnHeader(int rowIndex) {
        Row row = this.sheet.createRow(rowIndex);
        Cell cell = row.createCell(0);
        for (int i = 0; i < 24; ++i) {
            cell = row.createCell(i + 1);
            cell.setCellValue((double)(i + 1));
            cell.setCellStyle(this.getHeaderStyle());
        }
    }

    private CellStyle getHeaderStyle() {
        CellStyle style = this.wb.createCellStyle();
        style.setFillForegroundColor(IndexedColors.BLACK.getIndex());
        style.setFillPattern((short)1);
        Font f = this.wb.createFont();
        f.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(f);
        style.setAlignment((short)2);
        return style;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("A01", "x");
        map.put("A03", "x");
        map.put("A04", "y");
        new ListToPlate(new File("test.xls"), map);
    }
}

