/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.DirectoryWalker;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.IOUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class TagDump {
    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(TagDumpArgs.class);
            TagDumpArgs argsp = (TagDumpArgs)cli.parseArguments(args);
            File outputFile = new File(argsp.getOutputFile());
            String datasetFolder = argsp.getGseOrBseFolder();
            TreeMap<String, ArrayList<String>> tagToGses = new TreeMap<String, ArrayList<String>>(String.CASE_INSENSITIVE_ORDER);
            List<File> tagFiles = new TagFileWalker().list(new File(datasetFolder));
            for (File tagFile : tagFiles) {
                String[][] tagFileData = ((Array2DContentHandler)new ExcelReader(tagFile.getCanonicalPath(), 1, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
                String[] header = tagFileData[0];
                TIntArrayList pColumns = new TIntArrayList();
                for (int i = 0; i < header.length; ++i) {
                    if (!header[i].toLowerCase().startsWith("p:")) continue;
                    pColumns.add(i);
                }
                int ntags = pColumns.size();
                for (int tagIndex = 0; tagIndex < ntags; ++tagIndex) {
                    int tagColumnIndex = pColumns.getQuick(tagIndex);
                    String tagName = header[tagColumnIndex].substring("p:".length()).trim();
                    int nsamples = tagFileData.length;
                    for (int i = 1; i < nsamples; ++i) {
                        String[] row = tagFileData[i];
                        String value = row[tagColumnIndex].trim();
                        if (value.equals("") || value.equals("-666")) continue;
                        ArrayList<String> gses = (ArrayList<String>)tagToGses.get(value);
                        if (gses == null) {
                            gses = new ArrayList<String>();
                            tagToGses.put(value, gses);
                        }
                        gses.add(IOUtil.getBaseFileName(tagFile));
                    }
                }
            }
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (String tag : tagToGses.keySet()) {
                pw.print(tag);
                pw.print("\t");
                List gses = (List)tagToGses.get(tag);
                int size = gses.size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    pw.print((String)gses.get(i));
                }
                pw.println();
            }
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    private static class TagFileWalker
    extends DirectoryWalker {
        public TagFileWalker() {
            super(null, 2);
        }

        public List<File> list(File startDirectory) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(startDirectory, results);
            return results;
        }

        protected File[] filterDirectoryContents(File directory, int depth, File[] files) {
            if (depth == 0) {
                return files;
            }
            ArrayList<File> tags = new ArrayList<File>();
            for (File file : files) {
                String name = file.getName();
                if (!name.toLowerCase().contains("_tag")) continue;
                tags.add(file);
            }
            return tags.toArray(new File[0]);
        }

        protected void handleFile(File file, int depth, Collection results) {
            if (depth == 2) {
                results.add(file);
            }
        }
    }

    @CommandLineInterface(application="tag_dump")
    public static interface TagDumpArgs {
        @Option(shortName={"d"}, longName={"dataset"}, description="the dataset folder (most likely either /xchip/cogs/bged/GSE or /xchip/cogs/bged/BSE)", defaultValue={"/xchip/cogs/bged/GSE"})
        public String getGseOrBseFolder();

        @Option(shortName={"o"}, description="the output file (default is tag_dump.tab)", defaultValue={"tag_dump.tab"})
        public String getOutputFile();

        @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
        public boolean getHelp();
    }
}

