/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.geo;

import gnu.trove.list.array.TIntArrayList;
import java.util.Map;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.DatasetColumnView;

public class AffyQCStats {
    private char biobPCall;
    private float gap35Ratio;
    private float act35Ratio;
    private float gap3mRatio;
    private float act3mRatio;
    private float meanInt;
    private float sdInt;
    private float medianInt;
    private float minInt;
    private float minRob10;
    private float maxInt;
    private float maxRob10;
    private float pcall;
    private float mcall;
    private float acall;
    private float[] spikeIntensity;
    private boolean spkAscend;

    public AffyQCStats(DatasetColumnView columnView, Map<String, Integer> probeIdToRowIndex) {
        int i;
        this.meanInt = FloatListStatUtils.mean(columnView);
        this.sdInt = FloatListStatUtils.stdev(columnView);
        this.medianInt = FloatListStatUtils.median(columnView);
        this.minInt = FloatListStatUtils.min(columnView);
        this.maxInt = FloatListStatUtils.max(columnView);
        float q2 = FloatListStatUtils.percentile(columnView, 10);
        TIntArrayList indices = new TIntArrayList();
        int nrows = columnView.size();
        for (int i2 = 0; i2 < nrows; ++i2) {
            float value = columnView.getValue(i2);
            if (!(value <= q2)) continue;
            indices.add(i2);
        }
        columnView.setIndices(indices.toArray());
        this.minRob10 = FloatListStatUtils.mean(columnView);
        columnView.setIndices(null);
        float q3 = FloatListStatUtils.percentile(columnView, 90);
        indices = new TIntArrayList();
        int nrows2 = columnView.size();
        for (int i3 = 0; i3 < nrows2; ++i3) {
            float value = columnView.getValue(i3);
            if (!(value >= q3)) continue;
            indices.add(i3);
        }
        columnView.setIndices(indices.toArray());
        this.maxRob10 = FloatListStatUtils.mean(columnView);
        columnView.setIndices(null);
        float p = 0.0f;
        float a = 0.0f;
        float m = 0.0f;
        int nrows3 = columnView.size();
        for (int i4 = 0; i4 < nrows3; ++i4) {
            Character call = (Character)columnView.getObjectValue(i4, 1);
            if (call == null) continue;
            if (call.charValue() == 'A') {
                a += 1.0f;
                continue;
            }
            if (call.charValue() == 'P') {
                p += 1.0f;
                continue;
            }
            if (call.charValue() != 'M') continue;
            m += 1.0f;
        }
        float total = a + p + m;
        this.pcall = 100.0f * (p / total);
        this.mcall = 100.0f * (m / total);
        this.acall = 100.0f * (a / total);
        String[] num = new String[]{"AFFX-HUMGAPDH/M33197_3_at", "AFFX-HSAC07/X00351_3_at", "AFFX-HUMGAPDH/M33197_3_at", "AFFX-HSAC07/X00351_3_at"};
        String[] denom = new String[]{"AFFX-HUMGAPDH/M33197_5_at", "AFFX-HSAC07/X00351_5_at", "AFFX-HUMGAPDH/M33197_M_at", "AFFX-HSAC07/X00351_M_at"};
        float[] ratios = new float[num.length];
        for (int i5 = 0; i5 < denom.length; ++i5) {
            ratios[i5] = columnView.getValue(probeIdToRowIndex.get(num[i5])) / columnView.getValue(probeIdToRowIndex.get(denom[i5]));
        }
        this.gap35Ratio = ratios[0];
        this.act35Ratio = ratios[1];
        this.gap3mRatio = ratios[2];
        this.act3mRatio = ratios[3];
        String[] spikes = new String[]{"AFFX-r2-Ec-bioB-3_at", "AFFX-r2-Ec-bioC-3_at", "AFFX-r2-Ec-bioD-3_at", "AFFX-r2-P1-cre-3_at"};
        boolean alternateSpikes = false;
        for (i = 0; i < spikes.length; ++i) {
            if (probeIdToRowIndex.containsKey(spikes[i])) continue;
            alternateSpikes = true;
            break;
        }
        if (alternateSpikes) {
            spikes = new String[]{"AFFX-BioB-3_at", "AFFX-BioC-3_at", "AFFX-BioDn-3_at", "AFFX-CreX-3_at"};
        }
        this.biobPCall = ((Character)columnView.getObjectValue(probeIdToRowIndex.get(spikes[0]), 1)).charValue();
        this.spikeIntensity = new float[spikes.length];
        this.spkAscend = true;
        for (i = 0; i < spikes.length; ++i) {
            float value = columnView.getValue(probeIdToRowIndex.get(spikes[i]));
            if (i > 0 && value <= columnView.getValue(probeIdToRowIndex.get(spikes[i - 1]))) {
                this.spkAscend = false;
            }
            this.spikeIntensity[i] = value;
        }
    }

    public float getAcall() {
        return this.acall;
    }

    public float getAct35Ratio() {
        return this.act35Ratio;
    }

    public float getAct3mRatio() {
        return this.act3mRatio;
    }

    public char getBiobPCall() {
        return this.biobPCall;
    }

    public float getGap35Ratio() {
        return this.gap35Ratio;
    }

    public float getGap3mRatio() {
        return this.gap3mRatio;
    }

    public float getMaxInt() {
        return this.maxInt;
    }

    public float getMaxRob10() {
        return this.maxRob10;
    }

    public float getMcall() {
        return this.mcall;
    }

    public float getMeanInt() {
        return this.meanInt;
    }

    public float getMedianInt() {
        return this.medianInt;
    }

    public float getMinInt() {
        return this.minInt;
    }

    public float getMinRob10() {
        return this.minRob10;
    }

    public float getPcall() {
        return this.pcall;
    }

    public float getSdInt() {
        return this.sdInt;
    }

    public float[] getSpikeIntensity() {
        return this.spikeIntensity;
    }

    public boolean isSpkAscend() {
        return this.spkAscend;
    }
}

