/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.geo;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class GEODownloadUtil {
    private static FTPClient ftp;

    public static synchronized boolean downloadGpl(String gpl, File dest) throws IOException {
        GEODownloadUtil.init();
        String dir = GEODownloadUtil.getGplFtpDir(gpl);
        try {
            ftp.chdir(dir);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            ftp.get(dest.getCanonicalPath(), gpl + "_family.soft.gz");
            return true;
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
    }

    public static synchronized boolean downloadGSMCelFile(String gsm, File destGzCelFile) throws Exception {
        GEODownloadUtil.init();
        gsm = gsm.toUpperCase();
        String dir = GEODownloadUtil.getSampleFtpDir(gsm);
        try {
            ftp.chdir(dir);
            String[] files = ftp.dir();
            if (files != null) {
                for (String f : files) {
                    String name = f.toUpperCase();
                    if (!name.startsWith(gsm) || !name.endsWith(".CEL.GZ")) continue;
                    ftp.get(destGzCelFile.getCanonicalPath(), f);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getGSMIdsForGSE(String gse) throws IOException {
        String url = GEODownloadUtil.getSoftFileUrl(gse);
        try (InputStream is = null;){
            is = new URL(url).openStream();
            ArrayList<String> ids = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(is), 0x100000);
            String s = null;
            while ((s = br.readLine()) != null) {
                if (!s.startsWith("!Series_sample_id")) continue;
                String attributeValue = s.substring(s.indexOf("=") + 1).trim();
                ids.add(attributeValue);
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
    }

    public static String getSoftFileUrl(String id) {
        return "http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=" + id.toUpperCase() + "&targ=self&form=text&view=full";
    }

    private static String getCelFileURLBase(String gsm) {
        String celFileUrl = "ftp://ftp.ncbi.nih.gov" + GEODownloadUtil.getSampleFtpDir(gsm) + "/" + gsm;
        return celFileUrl;
    }

    private static String getGplFtpDir(String gpl) {
        String num = gpl.substring(3);
        String nnn = "GPL" + (num.length() <= 3 ? "" : num.substring(0, num.length() - 3)) + "nnn";
        return "/geo/platforms/" + nnn + "/" + gpl + "/soft";
    }

    private static String getSampleFtpDir(String gsm) {
        String num = gsm.substring(3);
        String nnn = "GSM" + (num.length() <= 3 ? "" : num.substring(0, num.length() - 3)) + "nnn";
        return "/pub/geo/DATA/supplementary/samples/" + nnn + "/" + gsm;
    }

    private static synchronized void init() {
        if (ftp == null) {
            try {
                FTPClient ftp = new FTPClient();
                ftp.setTimeout(2000);
                ftp.setRetryCount(0);
                ftp.setRemoteHost("ftp.ncbi.nih.gov");
                ftp.connect();
                ftp.login("anonymous", "anonymous");
                ftp.setType(FTPTransferType.BINARY);
                GEODownloadUtil.ftp = ftp;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (!ftp.connected()) {
            try {
                ftp.setRemoteHost("ftp.ncbi.nih.gov");
                ftp.connect();
                ftp.login("anonymous", "anonymous");
                ftp.setType(FTPTransferType.BINARY);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

