/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.query;

import com.jidesoft.swing.AutoResizingTextArea;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.OverlayHider;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.gui.parameters.RadioButtonParameter;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetPair;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetMatrix;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetPair;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class CustomSignatureQueryAction
extends AbstractInputAction {
    private static final String QUERY_NAME = "Query Name";
    private static final String INPUT_METHOD = "Input method";
    private static final int GMT_SELECTION = 0;
    private static final int GRP_SELECTION = 1;
    private static final int TXT_SELECTION = 2;
    private File downFile;
    private GeneSetMatrix downSets;
    private FileInputParameter downTagsFileInput;
    private DefaultOverlayable downTagsOverlayable;
    private JTextArea downTagsTextArea;
    private File upFile;
    private GeneSetMatrix upSets;
    private FileInputParameter upTagsFileInput;
    private DefaultOverlayable upTagsOverlayable;
    private JTextArea upTagsTextArea;
    private JPanel grpPanel;
    private JPanel textInputPanel;
    private FileInputParameter gmtFileInput;
    private JPanel gmtPanel;
    private JPanel currentPanel;
    private File gmtFile;
    private RadioButtonParameter inputMethodChooser = new RadioButtonParameter(new String[]{"GMT File", "GRP File", "Text"}, 2);
    private JPanel mainPanel;

    public CustomSignatureQueryAction() {
        super("Query");
        this.addParameter(INPUT_METHOD, this.inputMethodChooser, true);
        this.addParameter(QUERY_NAME, new TextFieldInputParameter(), false);
        this.upTagsTextArea = new AutoResizingTextArea(2, 10, 20);
        this.downTagsTextArea = new AutoResizingTextArea(2, 10, 20);
        this.upTagsOverlayable = new DefaultOverlayable((JComponent)UIUtil.createNoBorderScrollPane(this.upTagsTextArea));
        this.upTagsOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)"{Enter one tag per line:f:gray}"));
        this.downTagsOverlayable = new DefaultOverlayable((JComponent)UIUtil.createNoBorderScrollPane(this.downTagsTextArea));
        this.downTagsOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)"{Enter one tag per line:f:gray}"));
        new OverlayHider(this.upTagsOverlayable, this.upTagsTextArea);
        new OverlayHider(this.downTagsOverlayable, this.downTagsTextArea);
        FormBuilder grpFormBuilder = new FormBuilder();
        grpFormBuilder.nextRow();
        grpFormBuilder.addLabel("Up GRP File:");
        this.upTagsFileInput = new FileInputParameter("", FileInputParameter.OPEN_FILE);
        grpFormBuilder.add(this.upTagsFileInput);
        grpFormBuilder.nextRow();
        grpFormBuilder.addLabel("Down GRP File:");
        this.downTagsFileInput = new FileInputParameter("", FileInputParameter.OPEN_FILE);
        grpFormBuilder.add(this.downTagsFileInput);
        this.grpPanel = grpFormBuilder.getPanel();
        FormBuilder gmtFormBuilder = new FormBuilder();
        gmtFormBuilder.nextRow();
        gmtFormBuilder.addLabel("GMT File:");
        this.gmtFileInput = new FileInputParameter("", FileInputParameter.OPEN_FILE);
        gmtFormBuilder.add(this.gmtFileInput);
        this.gmtPanel = gmtFormBuilder.getPanel();
        FormBuilder txtFormBuilder = new FormBuilder();
        txtFormBuilder.nextRow();
        txtFormBuilder.addLabel("Up tags:");
        txtFormBuilder.add((Component)this.upTagsOverlayable);
        txtFormBuilder.nextRow();
        txtFormBuilder.addLabel("Down tags:");
        txtFormBuilder.add((Component)this.downTagsOverlayable);
        this.textInputPanel = txtFormBuilder.getPanel();
        this.inputMethodChooser.getButtonGroupHelper().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel visiblePanel = null;
                int selection = CustomSignatureQueryAction.this.inputMethodChooser.getSelectedIndex();
                if (selection == 0) {
                    visiblePanel = CustomSignatureQueryAction.this.gmtPanel;
                } else if (selection == 1) {
                    visiblePanel = CustomSignatureQueryAction.this.grpPanel;
                } else if (selection == 2) {
                    visiblePanel = CustomSignatureQueryAction.this.textInputPanel;
                }
                CustomSignatureQueryAction.this.mainPanel.remove(CustomSignatureQueryAction.this.currentPanel);
                CustomSignatureQueryAction.this.currentPanel = visiblePanel;
                CustomSignatureQueryAction.this.mainPanel.add(visiblePanel);
                visiblePanel.revalidate();
                visiblePanel.repaint();
            }
        });
        this.currentPanel = this.textInputPanel;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.currentPanel);
        this.getInputPanelBuilder().getFormBuilder().addSpanned(this.mainPanel);
        FormBuilder.setToMaxWidth(this.getInputPanelBuilder().getFormBuilder(), gmtFormBuilder, grpFormBuilder, txtFormBuilder);
    }

    public GeneSetPair[] getGeneSetPairs(String queryName) {
        int selection = this.inputMethodChooser.getSelectedIndex();
        if (selection == 1) {
            if (this.downFile != null) {
                try {
                    this.downSets = GeneSetIO.readGeneSetMatrix(this.downFile);
                }
                catch (Exception e) {
                    this.downSets = null;
                }
            }
            if (this.upFile != null) {
                try {
                    this.upSets = GeneSetIO.readGeneSetMatrix(this.upFile);
                }
                catch (Exception e) {
                    this.upSets = null;
                }
            }
        } else if (selection == 0) {
            try {
                GeneSetMatrix sets = GeneSetIO.readGeneSetMatrix(this.gmtFile);
                LinkedHashMap<String, GeneSet[]> baseNameToSets = new LinkedHashMap<String, GeneSet[]>();
                int nsets = sets.getNumGeneSets();
                for (int i = 0; i < nsets; ++i) {
                    GeneSet set = sets.get(i);
                    String name = set.getName();
                    String lc = name.toLowerCase();
                    String baseName = null;
                    boolean down = false;
                    if (lc.endsWith("_down")) {
                        baseName = name.substring(0, name.length() - "_down".length());
                        down = true;
                    } else if (lc.endsWith("_up")) {
                        baseName = name.substring(0, name.length() - "_up".length());
                    }
                    if (baseName == null) continue;
                    GeneSet[] upDown = (GeneSet[])baseNameToSets.get(baseName);
                    if (upDown == null) {
                        upDown = new GeneSet[2];
                        baseNameToSets.put(baseName, upDown);
                    }
                    upDown[down ? 1 : 0] = set;
                }
                ArrayList<DefaultGeneSetPair> pairs = new ArrayList<DefaultGeneSetPair>();
                for (String name : baseNameToSets.keySet()) {
                    GeneSet[] upDown = (GeneSet[])baseNameToSets.get(name);
                    GeneSet upSet = upDown[0];
                    GeneSet downSet = upDown[1];
                    if ("".equals(queryName)) {
                        queryName = upSet.getName() + "_" + downSet.getName();
                    }
                    pairs.add(new DefaultGeneSetPair(queryName, upSet, downSet));
                }
                return pairs.toArray(new GeneSetPair[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            GeneSetPair[] pairs = new GeneSetPair[this.upSets.getNumGeneSets()];
            int size = this.upSets.getNumGeneSets();
            for (int i = 0; i < size; ++i) {
                GeneSet upSet = this.upSets.get(i);
                GeneSet downSet = this.downSets.get(i);
                if ("".equals(queryName)) {
                    queryName = upSet.getName() + "_" + downSet.getName();
                }
                pairs[i] = new DefaultGeneSetPair(queryName, upSet, downSet);
            }
            return pairs;
        }
        return null;
    }

    @Override
    protected void customizeMap(Project p, Map<String, Object> map) {
        ArrayList<String> problems = new ArrayList<String>();
        int selection = this.inputMethodChooser.getSelectedIndex();
        if (selection == 1) {
            this.upFile = this.upTagsFileInput.getFile();
            if (this.upFile.getName().equals("")) {
                problems.add("Please provide an up tags file.");
            } else if (!this.upFile.exists()) {
                problems.add("Up tags file not found.");
            }
            this.downFile = this.downTagsFileInput.getFile();
            if (this.downFile.getName().equals("")) {
                problems.add("Please provide a down tags file.");
            } else if (!this.downFile.exists()) {
                problems.add("Down tags file not found.");
            }
        } else if (selection == 2) {
            String[] tokens;
            this.upFile = null;
            this.downFile = null;
            String upTagsText = this.upTagsTextArea.getText().trim();
            HashSet<String> upTags = new HashSet<String>();
            for (String token : tokens = upTagsText.split("\n")) {
                if ("".equals(token = token.trim())) continue;
                upTags.add(token);
            }
            if (upTags.size() == 0) {
                problems.add("Please provide up tags.");
            }
            String downTagsText = this.downTagsTextArea.getText().trim();
            HashSet<String> downTags = new HashSet<String>();
            for (String token : tokens = downTagsText.split("\n")) {
                if ("".equals(token = token.trim())) continue;
                downTags.add(token);
            }
            if (downTags.size() == 0) {
                problems.add("Please provide down tags.");
            }
            this.upSets = new DefaultGeneSetMatrix("up", Arrays.asList(new DefaultGeneSet("up", upTags)));
            this.downSets = new DefaultGeneSetMatrix("down", Arrays.asList(new DefaultGeneSet("down", downTags)));
        } else {
            this.gmtFile = this.gmtFileInput.getFile();
            if (this.gmtFile.getName().equals("")) {
                problems.add("Please provide a gmt file.");
            } else if (!this.gmtFile.exists()) {
                problems.add("GMT file not found.");
            }
        }
        if (problems.size() > 0) {
            UIUtil.showErrorDialog(this.currentPanel, ToStringUtil.toString(problems, ", "));
            throw new RuntimeException();
        }
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> inputMap, ProgressNotifier status) throws Exception {
        return null;
    }

    public static void main(String[] args) {
        UIUtil.showInFrame(new CustomSignatureQueryAction().getInputPanelBuilder().getFormBuilder().getPanel());
    }
}

