/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.rankedlist.DefaultRankedList;

public class CMapWebsiteBuild2ResultsReader {
    public static DefaultRankedList readCmapResult(String file) throws Exception {
        String[][] data = ((Array2DContentHandler)new ExcelReader(file, new Array2DContentHandler()).getContentHandler()).getData();
        String[] ids = new String[data.length - 1];
        float[] scores = new float[data.length - 1];
        int scoreIndex = 5;
        int idIndex = 9;
        DefaultMetadataModel metadata = new DefaultMetadataModel(data.length - 1);
        int length = data[0].length;
        for (int j = 1; j < length; ++j) {
            if (j == scoreIndex || j == idIndex) continue;
            data[0][j] = data[0][j].trim();
            String columnName = data[0][j];
            if (columnName.equals("dose") || columnName.equals("up") || columnName.equals("down")) {
                metadata.add(columnName, Float.class);
                continue;
            }
            metadata.add(columnName, String.class);
        }
        length = data.length;
        for (int i = 1; i < length; ++i) {
            String id;
            String[] array = data[i];
            scores[i - 1] = ParserHelper.parseFloat(array[scoreIndex]);
            ids[i - 1] = id = array[idIndex];
            int cols = data[0].length;
            for (int j = 1; j < cols; ++j) {
                if (j == scoreIndex || j == idIndex) continue;
                String columnName = data[0][j];
                if (columnName.equals("dose")) {
                    String text = array[j];
                    float mult = 1.0f;
                    if (text.contains("M")) {
                        text = text.replace("M", "").trim();
                    } else if (text.contains("nM")) {
                        text = text.replace("nM", "").trim();
                        mult = 0.001f;
                    } else if (text.contains("mM")) {
                        mult = 1000.0f;
                        text = text.replace("mM", "").trim();
                    } else {
                        throw new RuntimeException();
                    }
                    metadata.setValue(i - 1, columnName, (Object)Float.valueOf(mult * ParserHelper.parseFloat(text)));
                    continue;
                }
                if (columnName.equals("up") || columnName.equals("down")) {
                    metadata.setValue(i - 1, columnName, (Object)Float.valueOf(ParserHelper.parseFloat(array[j])));
                    continue;
                }
                metadata.setValue(i - 1, columnName, (Object)array[j]);
            }
        }
        return null;
    }
}

