/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilter;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionEvent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionListener;

public class RankedListFilterCollection {
    private List<RankedListFilter> filters = new ArrayList<RankedListFilter>();
    private Set<Object> instanceIds = Collections.emptySet();
    private UniqueEventListenerList listenerList = new UniqueEventListenerList();

    public void addFilter(RankedListFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(filter);
        }
        this.update();
    }

    public void addRankedListFilterListener(RankedListFilterCollectionListener l) {
        this.listenerList.add(RankedListFilterCollectionListener.class, l);
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public Set<Object> getInstanceIds() {
        return this.instanceIds;
    }

    public void removeFilter(RankedListFilter filter) {
        this.filters.remove(filter);
        this.update();
    }

    public void removeRankedListFilterListener(RankedListFilterCollectionListener l) {
        this.listenerList.remove(RankedListFilterCollectionListener.class, l);
    }

    public void setInstanceIds(Set<Object> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public int size() {
        return this.instanceIds.size();
    }

    public void update() {
        this.instanceIds = new HashSet<Object>();
        if (this.filters.size() > 0) {
            int firstActiveFilter = -1;
            int size = this.filters.size();
            for (int i = 0; i < size; ++i) {
                if (!this.filters.get(i).isEnabled() || !this.filters.get(i).isValid()) continue;
                firstActiveFilter = i;
                break;
            }
            if (firstActiveFilter != -1) {
                Collection<Object> ids = this.filters.get(firstActiveFilter).getIds();
                this.instanceIds.addAll(ids);
                int size2 = this.filters.size();
                for (int i = firstActiveFilter + 1; i < size2; ++i) {
                    RankedListFilter filter = this.filters.get(i);
                    if (!this.filters.get(i).isEnabled() || !this.filters.get(i).isValid()) continue;
                    this.instanceIds.retainAll(filter.getIds());
                }
            }
        }
        this.fireFilterChanged();
    }

    private void fireFilterChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        RankedListFilterCollectionEvent e = new RankedListFilterCollectionEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RankedListFilterCollectionListener.class) continue;
            ((RankedListFilterCollectionListener)listeners[i + 1]).filterChanged(e);
        }
    }
}

