/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.rankedlist;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilter;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollection;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionEvent;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterCollectionListener;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterData;
import org.broadinstitute.genee.cmap.rankedlist.RankedListFilterResultsCollector;
import org.broadinstitute.genee.filter.CheckBoxListFilterUI;
import org.broadinstitute.genee.filter.CheckBoxSelectorComponent;
import org.broadinstitute.genee.filter.FilterDialog;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.RankedListFilterableAttribute;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.grid.DragDropButton;
import org.broadinstitute.genee.gui.grid.DragDropComponent;
import org.broadinstitute.genee.gui.grid.DragOwner;
import org.broadinstitute.genee.gui.grid.DropListPanel;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;

public class RankedListFilterDropPanel
extends DropListPanel {
    private RankedListFilterCollection rankedListFilterCollection;
    private RankedList rankedList;
    private JLabel filterLabel;

    public RankedListFilterDropPanel(final RankedList rankedList) {
        super(new Class[]{RankedListFilterableAttribute.class, RankedListFilterData.class, DragDropComponent.class}, true, true, null, "Filters");
        this.rankedList = rankedList;
        this.filterLabel = new JLabel(" ");
        this.rankedListFilterCollection = new RankedListFilterCollection();
        this.rankedListFilterCollection.addRankedListFilterListener(new RankedListFilterCollectionListener(){

            @Override
            public void filterChanged(RankedListFilterCollectionEvent e) {
                if (RankedListFilterDropPanel.this.rankedListFilterCollection.getFilterCount() == 0) {
                    RankedListFilterDropPanel.this.filterLabel.setText(" ");
                } else {
                    RankedListFilterDropPanel.this.filterLabel.setText(RankedListFilterDropPanel.this.rankedListFilterCollection.size() + " out of " + rankedList.size());
                }
            }
        });
    }

    public JLabel getFilterLabel() {
        return this.filterLabel;
    }

    public RankedListFilterCollection getRankedListFilterCollection() {
        return this.rankedListFilterCollection;
    }

    @Override
    public void removeDragDropComponent(DragDropComponent dragDropButton, boolean notify) {
        super.removeDragDropComponent(dragDropButton, notify);
        RankedListFilterData filterData = (RankedListFilterData)dragDropButton.getData();
        this.rankedListFilterCollection.removeFilter(filterData.getRankedListFilter());
        filterData.getFilterDialog().dispose();
    }

    public void programatticDrop(RankedListFilterableAttribute attribute, Collection items) {
        DragDropComponent dragDropComponent = this.drop(attribute, false);
        RankedListFilterData filterData = (RankedListFilterData)dragDropComponent.getData();
        CheckBoxListFilterUI filterUI = (CheckBoxListFilterUI)filterData.getFilterDialog().getFilterUI();
        CheckBoxSelectorComponent filterSelectionComponent = filterUI.getFilterSelectionComponent();
        filterSelectionComponent.setSelectedItems(items);
        filterData.getFilterDialog().apply();
    }

    @Override
    public void setOwner(DragDropComponent dragDropComponent, DragOwner owner) {
        if (dragDropComponent.getData() instanceof RankedListFilterData) {
            RankedListFilterData filterData = (RankedListFilterData)dragDropComponent.getData();
            dragDropComponent.setOwner(dragDropComponent.getData(), owner, filterData.getPopupMenuCustomizer());
            this.rankedListFilterCollection.addFilter(filterData.getRankedListFilter());
            filterData.getFilterDialog().show();
        } else {
            DragDropComponent btn = RankedListFilterDropPanel.createDragDropComponent(UIUtil.getWindowForComponent(this.getComponent()), (RankedListFilterableAttribute)dragDropComponent.getData(), this.rankedListFilterCollection, this.rankedList, owner, true);
            dragDropComponent.setOwner(btn.getData(), btn.getOwner(), btn.getMenuCustomizer());
        }
    }

    @Override
    protected DragDropComponent createDragDropComponent(Object transferData, DragOwner dragOwner, boolean interactive) {
        if (transferData instanceof RankedListFilterableAttribute) {
            DragDropComponent dragDropComponent = this.getDragDropComponent((RankedListFilterableAttribute)transferData);
            if (dragDropComponent != null) {
                ((RankedListFilterData)dragDropComponent.getData()).getFilterDialog().show();
                return dragDropComponent;
            }
            return RankedListFilterDropPanel.createDragDropComponent(UIUtil.getWindowForComponent(this.getComponent()), (RankedListFilterableAttribute)transferData, this.rankedListFilterCollection, this.rankedList, dragOwner, interactive);
        }
        throw new RuntimeException();
    }

    @Override
    public void notifyChanged(String sourceOwnerName, String destOwnerName) {
        List<DragDropComponent> dragDropComponents = this.getDragDropComponents(true);
        boolean changed = false;
        for (DragDropComponent c : dragDropComponents) {
            RankedListFilterData data = (RankedListFilterData)c.getData();
            boolean previous = data.getRankedListFilter().isEnabled();
            if (!changed) {
                changed = previous != c.isEnabled();
            }
            data.getRankedListFilter().setEnabled(c.isEnabled());
        }
        if (changed) {
            this.rankedListFilterCollection.update();
        }
    }

    private DragDropComponent getDragDropComponent(RankedListFilterableAttribute attribute) {
        List<DragDropComponent> dragDropComponents = this.getDragDropComponents();
        for (DragDropComponent dragDropComponent : dragDropComponents) {
            if (((RankedListFilterData)dragDropComponent.getData()).getFilterableAttribute() != attribute) continue;
            return dragDropComponent;
        }
        return null;
    }

    private static DragDropComponent createDragDropComponent(Container parent, RankedListFilterableAttribute attribute, RankedListFilterCollection rankedListFilterCollection, RankedList rankedList, DragOwner dragOwner, boolean interactive) {
        FilterUI rankedListFilterUI = attribute.createFilterUI();
        final RankedListFilter rankedListFilter = new RankedListFilter(rankedListFilterUI.getFilterName());
        rankedListFilter.setRankedListFilterCollection(rankedListFilterCollection);
        FilterDialog filterDialog = new FilterDialog(parent, rankedListFilterUI, attribute.getFilterValuesSupplier(), new RankedListFilterResultsCollector(rankedList)){

            @Override
            protected void notifyChanged() {
                rankedListFilter.setInstanceIds(this.filterResultsCollector.getResults());
            }
        };
        RankedListFilterPopupMenuCustomizer popupMenuCustomizer = new RankedListFilterPopupMenuCustomizer(filterDialog);
        if (interactive) {
            filterDialog.show();
        }
        return new DragDropButton(new RankedListFilterData(attribute, filterDialog, rankedListFilter, attribute.getFilterValuesSupplier(), popupMenuCustomizer), dragOwner, popupMenuCustomizer);
    }

    private static class RankedListFilterPopupMenuCustomizer
    implements DragDropButton.PopupMenuCustomizer {
        private AbstractAction filterAction;

        private RankedListFilterPopupMenuCustomizer(final FilterDialog filterDialog) {
            this.filterAction = new AbstractAction("Filter"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    filterDialog.show();
                }
            };
        }

        @Override
        public void customize(JMenu menu, Object data) {
            menu.add(this.filterAction);
        }
    }
}

