/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.cmap.scripts.ScriptUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.matrix.geneset.GrpReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class BgedXtract {
    public BgedXtract(BgedXtractArgs argsp) throws Exception {
        GctxReader reader = new GctxReader(argsp.getH5File());
        Set<String> phenotypes = new GrpReader().read(argsp.getGrpFile()).get(0).getMembers();
        Map sampleIdToIndex = VectorUtil.buildIndexMap(reader.getRowsOrColumns(false).get(0));
        LinkedHashSet<Integer> sampleIndices = new LinkedHashSet<Integer>();
        HashMap<String, HashMap<String, String>> metadataNameToSampleToValue = new HashMap<String, HashMap<String, String>>();
        for (String p : phenotypes) {
            int i;
            int underscore = p.indexOf(95);
            String gse = p.substring(0, underscore).toUpperCase();
            String s = "p:" + p.substring(underscore + 1);
            File tagDir = new File("/xchip/cogs/bged/GSE", gse);
            File[] xlsFiles = tagDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith("_tag.xls");
                }
            });
            if (xlsFiles.length > 1) {
                throw new RuntimeException("Tag file not found for " + gse);
            }
            String[][] tagFileData = ((Array2DContentHandler)new ExcelReader(xlsFiles[0].getCanonicalPath(), 1, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
            String[] header = tagFileData[0];
            int pIndex = -1;
            int length = header.length;
            for (int i2 = 1; i2 < length; ++i2) {
                if (!header[i2].equalsIgnoreCase(s)) continue;
                pIndex = i2;
                break;
            }
            if (pIndex == -1) {
                throw new RuntimeException(s + " not found in " + xlsFiles[0]);
            }
            TIntArrayList pIndices = new TIntArrayList();
            ArrayList<String> tagNames = new ArrayList<String>();
            int length2 = header.length;
            for (i = 1; i < length2; ++i) {
                if (!header[i].toLowerCase().startsWith("p:")) continue;
                pIndices.add(i);
                tagNames.add(header[i]);
            }
            length2 = tagFileData.length;
            for (i = 1; i < length2; ++i) {
                String val = tagFileData[i][pIndex];
                if (val == null || val.equals("") || val.equals("-666")) continue;
                String id = tagFileData[i][0];
                Integer sampleIndex = sampleIdToIndex.get(id);
                if (sampleIndex == null) {
                    throw new RuntimeException(id + " not found.");
                }
                sampleIndices.add(sampleIndex);
                int npCols = pIndices.size();
                for (int j = 0; j < npCols; ++j) {
                    int pColumnIndex = pIndices.getQuick(j);
                    String tagValue = tagFileData[i][pColumnIndex];
                    String tagName = (String)tagNames.get(j);
                    HashMap<String, String> sampleToValue = (HashMap<String, String>)metadataNameToSampleToValue.get(tagName);
                    if (sampleToValue == null) {
                        sampleToValue = new HashMap<String, String>();
                        metadataNameToSampleToValue.put(tagName, sampleToValue);
                    }
                    sampleToValue.put(id, tagValue);
                }
            }
        }
        System.out.println("Found " + sampleIndices.size() + " samples");
        Dataset dataset = reader.read(null, IOUtil.toIntArray(sampleIndices), true, true, false, false);
        reader.close();
        Vector[] vectors = new Vector[metadataNameToSampleToValue.size()];
        String[] names = metadataNameToSampleToValue.keySet().toArray(new String[0]);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            vectors[i] = MetadataUtil.addColumnVector(dataset.getColumnMetadata(), name, String.class);
        }
        Vector ids = dataset.getColumnMetadata().get(0);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(argsp.getSampleAnnotationFile())));
        pw.print("Name");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            pw.print("\t");
            pw.print(name);
        }
        pw.println();
        int ncols = ids.size();
        for (int j = 0; j < ncols; ++j) {
            String id = (String)ids.getValue(j);
            pw.print(id);
            for (int i = 0; i < names.length; ++i) {
                Map sampleToValue = (Map)metadataNameToSampleToValue.get(names[i]);
                String value = (String)sampleToValue.get(id);
                vectors[i].setValue(j, value);
                pw.print("\t");
                pw.print(value == null ? "" : value);
            }
            pw.println();
        }
        File outputFile = argsp.isOutputGctFile() ? argsp.getOutputGctFile() : new File(ScriptUtil.getOutputDir(argsp), IOUtil.getBaseFileName(argsp.getGrpFile()));
        ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", outputFile.getCanonicalPath(), true);
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(BgedXtractArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            BgedXtractArgs argsp = (BgedXtractArgs)cli.parseArguments(args);
            new BgedXtract(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="bged_xtract - extract a subset of bged.")
    public static interface BgedXtractArgs {
        @Option(shortName={"g"}, longName={"grp"}, description="path to GRP file of phenotypes")
        public String getGrpFile();

        @Option(shortName={"i"}, longName={"h5"}, description="path to H5 file", defaultValue={"/xchip/cogs/jgould/bged_v2.h5"})
        public String getH5File();

        @Option(shortName={"o"}, longName={"gct"}, description="path to output gct file")
        public File getOutputGctFile();

        public boolean isOutputGctFile();

        @Option(shortName={"s"}, longName={"annot"}, description="path to output sample annotation file")
        public String getSampleAnnotationFile();

        @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
        public boolean getHelp();
    }
}

