/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class CreateGctFromCmapBuild2 {
    public static void main(String[] args) throws Exception {
        File[] files = new File[]{new File("/Users/jgould/Downloads/detailedResults60621.xls"), new File("/Users/jgould/Downloads/detailedResults60622.xls")};
        ProjectIO.writeProject((Project)new DefaultProject(CreateGctFromCmapBuild2.createDataset(files)), "gctx", "cmap", true);
    }

    public static Dataset createDataset(File[] files) throws IOException {
        String[][] data = ((Array2DContentHandler)new ExcelReader(files[0].getCanonicalPath(), new Array2DContentHandler()).getContentHandler()).getData();
        int rows = data.length - 1;
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", rows, files.length);
        Vector columnIds = dataset.getColumnMetadata().add("Id", String.class);
        int size = columnIds.size();
        for (int i = 0; i < size; ++i) {
            columnIds.setValue(i, "" + (i + 1));
        }
        Vector instanceId = dataset.getRowMetadata().add("Instance Id", String.class);
        Vector batch = dataset.getRowMetadata().add("Batch", String.class);
        Vector cell = dataset.getRowMetadata().add("Cell", String.class);
        Vector name = dataset.getRowMetadata().add("Name", String.class);
        Vector dose = dataset.getRowMetadata().add("Dose", String.class);
        Vector smile = dataset.getRowMetadata().add("SMILE", String.class);
        HashMap<String, Integer> instanceIdToIndex = new HashMap<String, Integer>();
        int length = data.length;
        for (int i = 1; i < length; ++i) {
            String[] row = data[i];
            batch.setValue(i - 1, row[1]);
            name.setValue(i - 1, row[2]);
            dose.setValue(i - 1, row[3]);
            cell.setValue(i - 1, row[4]);
            try {
                String cname = row[2];
                Molecule m = MolImporter.importMol((String)cname, (String)"name");
                smile.setValue(i - 1, MoleculeUtil.toSmile(m));
            }
            catch (Exception x) {
                // empty catch block
            }
            String instance = row[8];
            instanceId.setValue(i - 1, instance);
            instanceIdToIndex.put(instance, i - 1);
            float value = ParserHelper.parseFloat(row[5]);
            dataset.setValue(i - 1, 0, value);
        }
        int nfiles = files.length;
        for (int fileIndex = 1; fileIndex < nfiles; ++fileIndex) {
            data = ((Array2DContentHandler)new ExcelReader(files[fileIndex].getCanonicalPath(), new Array2DContentHandler()).getContentHandler()).getData();
            int length2 = data.length;
            for (int i = 1; i < length2; ++i) {
                String[] row = data[i];
                String instance = row[8];
                int rowIndex = (Integer)instanceIdToIndex.get(instance);
                dataset.setValue(rowIndex, fileIndex, ParserHelper.parseFloat(row[5]));
            }
        }
        return dataset;
    }
}

