/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.broadinstitute.genee.cmap.scripts.ScriptUtil;
import org.broadinstitute.genee.gui.NullProgressNotifier;
import org.broadinstitute.genee.io.luminex.LuminexCsvParser;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class CsvSummary {
    public CsvSummary(CsvSummaryArgs argsp) throws Exception {
        final Date date = argsp.isDate() ? new SimpleDateFormat("MM/dd/yyyy").parse(argsp.getDate()) : null;
        File[] csvs = IOUtil.listFiles(new File(argsp.getDir()), new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".csv") && (date == null || new Date(pathname.lastModified()).after(date));
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, new NullProgressNotifier(), true);
        File outputFile = argsp.isOutputFile() ? argsp.getOutputFile() : new File(ScriptUtil.getOutputDir(argsp), IOUtil.getBaseFileName(argsp.getDir()) + ".xls");
        PrintWriter pw = new PrintWriter(outputFile);
        String[] analytesArray = argsp.isAnalytes() ? argsp.getAnalytes().split(",") : new String[]{};
        TIntArrayList tmp = new TIntArrayList();
        for (String s : analytesArray) {
            s = s.trim();
            tmp.add(Integer.parseInt(s));
        }
        int[] analytes = tmp.toArray();
        pw.print("Plate\tScanner\tDate\tBatch\tRange\tSpan\tLevel One\tLevel Ten\tMedian Intensity\tMedian Count\tQ25 Count");
        for (int s : analytes) {
            pw.print("\t");
            pw.print(s + " Count");
        }
        pw.println("\tQC Report");
        for (File csv : csvs) {
            Map<String, String> map = LuminexCsvParser.getMetadata(csv.getCanonicalPath());
            RowMajorArray2DDataset medians = new LuminexCsvParser(csv.getCanonicalPath(), "Median").getDataset();
            pw.print(IOUtil.getBaseFileName(csv));
            pw.print("\t");
            pw.print(map.get("SN"));
            pw.print("\t");
            pw.print(map.get("Date"));
            pw.print("\t");
            pw.print(map.get("Batch"));
            float levelOne = FloatListStatUtils.median(DatasetUtil.floatListView(DatasetUtil.sliceView(medians, null, new int[]{0})));
            float levelTen = FloatListStatUtils.median(DatasetUtil.floatListView(DatasetUtil.sliceView(medians, null, new int[]{9})));
            pw.print("\t");
            pw.print(Formatter.format(levelTen / levelOne));
            pw.print("\t");
            pw.print(Formatter.format(levelTen - levelOne));
            pw.print("\t");
            pw.print(Formatter.format(levelOne));
            pw.print("\t");
            pw.print(Formatter.format(levelTen));
            pw.print("\t");
            pw.print(Formatter.format(FloatListStatUtils.percentile(DatasetUtil.floatListView(medians), 50)));
            RowMajorArray2DDataset counts = new LuminexCsvParser(csv.getCanonicalPath(), "Count").getDataset();
            pw.print("\t");
            pw.print(Formatter.format(FloatListStatUtils.percentile(DatasetUtil.floatListView(counts), 50)));
            pw.print("\t");
            pw.print(Formatter.format(FloatListStatUtils.percentile(DatasetUtil.floatListView(counts), 25)));
            for (int analyte : analytes) {
                pw.print("\t");
                pw.print(Formatter.format(FloatListStatUtils.percentile(DatasetUtil.floatListView(DatasetUtil.sliceView(counts, null, new int[]{analyte - 1})), 50)));
            }
            pw.print("\t");
            pw.print("http://www.broadinstitute.org/cogs/lims/qc.html#plate=" + IOUtil.getBaseFileName(csv));
            pw.println();
        }
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(CsvSummaryArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            CsvSummaryArgs argsp = (CsvSummaryArgs)cli.parseArguments(args);
            new CsvSummary(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="csv_summary")
    public static interface CsvSummaryArgs {
        @Option(shortName={"a"}, longName={"analytes"}, description="Comma separated list of counts to report for analytes")
        public String getAnalytes();

        public boolean isAnalytes();

        @Option(shortName={"d"}, longName={"dir"}, description="the root directory to search from")
        public String getDir();

        @Option(shortName={"o"}, longName={"output"}, description="the output file")
        public File getOutputFile();

        @Option(longName={"date"}, description="date to look after")
        public String getDate();

        public boolean isDate();

        public boolean isOutputFile();
    }
}

