/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.IOUtil;

public class ExcelToTxt {
    public static void main(String[] args) throws Exception {
        String[][] data;
        if (args.length == 0) {
            System.out.println("excel_to_txt excel_file [sheet]");
            System.exit(1);
        }
        String file = args[0];
        String outputFile = IOUtil.getBaseFileName(file);
        if (args.length > 1) {
            outputFile = outputFile + "_" + args[1];
            try {
                int sheet = Integer.parseInt(args[1]);
                data = ((Array2DContentHandler)new ExcelReader(file, sheet, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
            }
            catch (NumberFormatException x) {
                data = ((Array2DContentHandler)new ExcelReader(file, args[1], (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
            }
        } else {
            data = ((Array2DContentHandler)new ExcelReader(file, new Array2DContentHandler()).getContentHandler()).getData();
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile + ".txt")));
        for (String[] array : data) {
            int length = array.length;
            for (int j = 0; j < length; ++j) {
                if (j > 0) {
                    pw.print("\t");
                }
                pw.print(array[j]);
            }
            pw.println();
        }
        pw.close();
    }
}

