/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import gnu.trove.list.array.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class ListToGct {
    public ListToGct(ListToGctArgs argsp) throws Exception {
        String[][] data = ((Array2DContentHandler)new ExcelReader(argsp.getFile(), new Array2DContentHandler()).getContentHandler()).getData();
        List<String> header = Arrays.asList(data[0]);
        List<String> rowHeaders = argsp.getRows();
        List<String> columnHeaders = argsp.getColumns();
        int[] rows = new int[rowHeaders.size()];
        int nrows = rows.length;
        for (int i = 0; i < nrows; ++i) {
            rows[i] = header.indexOf(rowHeaders.get(i));
        }
        int[] columns = new int[columnHeaders.size()];
        int ncolumns = columns.length;
        for (int i = 0; i < ncolumns; ++i) {
            columns[i] = header.indexOf(columnHeaders.get(i));
        }
        int dataIndex = header.indexOf(argsp.getDataColumn());
        ArrayList<IdPair> pairs = new ArrayList<IdPair>();
        int length = data.length;
        for (int rowIndex = 1; rowIndex < length; ++rowIndex) {
            int i;
            String[] array = data[rowIndex];
            String[] rowArray = new String[rows.length];
            String[] columnArray = new String[columns.length];
            for (i = 0; i < nrows; ++i) {
                rowArray[i] = array[rows[i]];
            }
            for (i = 0; i < ncolumns; ++i) {
                columnArray[i] = array[columns[i]];
            }
            Identifier<String> rowId = new Identifier<String>(rowArray);
            Identifier<String> columnId = new Identifier<String>(columnArray);
            String s = array[dataIndex];
            float value = ParserHelper.parseFloatNaN(s);
            pairs.add(new IdPair(rowId, columnId, value));
        }
        HashMap<Identifier, Integer> rowIdToIndex = new HashMap<Identifier, Integer>();
        HashMap<Identifier, Integer> columnIdToIndex = new HashMap<Identifier, Integer>();
        int maxRowIndex = 0;
        int maxColumnIndex = 0;
        for (IdPair pair : pairs) {
            Integer rowIndex = (Integer)rowIdToIndex.get(pair.row);
            if (rowIndex == null) {
                rowIndex = maxRowIndex++;
            }
            rowIdToIndex.put(pair.row, rowIndex);
            Integer columnIndex = (Integer)columnIdToIndex.get(pair.column);
            if (columnIndex == null) {
                columnIndex = maxColumnIndex++;
            }
            columnIdToIndex.put(pair.column, columnIndex);
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", rowIdToIndex.size(), columnIdToIndex.size());
        for (String name : rowHeaders) {
            dataset.getRowMetadata().add(name, String.class);
        }
        for (String name : columnHeaders) {
            dataset.getColumnMetadata().add(name, String.class);
        }
        DatasetUtil.fill(dataset, Float.NaN);
        TFloatArrayList[][] floatListArray = new TFloatArrayList[dataset.getRowCount()][dataset.getColumnCount()];
        int rowCount = dataset.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int columnCount = dataset.getColumnCount();
            for (int j = 0; j < columnCount; ++j) {
                floatListArray[i][j] = new TFloatArrayList();
            }
        }
        for (IdPair pair : pairs) {
            int i;
            Integer rowIndex = (Integer)rowIdToIndex.get(pair.row);
            Integer columnIndex = (Integer)columnIdToIndex.get(pair.column);
            floatListArray[rowIndex][columnIndex].add(pair.value);
            for (i = 0; i < nrows; ++i) {
                dataset.getRowMetadata().get(i).setValue(rowIndex, pair.row.get(i));
            }
            for (i = 0; i < ncolumns; ++i) {
                dataset.getColumnMetadata().get(i).setValue(columnIndex, pair.column.get(i));
            }
        }
        rowCount = dataset.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int columnCount = dataset.getColumnCount();
            for (int j = 0; j < columnCount; ++j) {
                TFloatArrayList list = floatListArray[i][j];
                if (list.size() > 1) {
                    System.out.println("ASD");
                }
                float value = list.size() > 1 ? FloatListStatUtils.median(new TroveFloatList(list)) : list.getQuick(0);
                dataset.setValue(i, j, value);
            }
        }
        ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", IOUtil.getBaseFileName(argsp.getFile()), true);
    }

    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(ListToGctArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            ListToGctArgs argsp = (ListToGctArgs)cli.parseArguments(args);
            new ListToGct(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    private static class IdPair {
        private Identifier row;
        private Identifier column;
        private float value;

        public IdPair(Identifier row, Identifier column, float value) {
            this.row = row;
            this.column = column;
            this.value = value;
        }
    }

    @CommandLineInterface(application="list-to-gct")
    public static interface ListToGctArgs {
        @Option(shortName={"c"}, longName={"columns"}, description="the columns")
        public List<String> getColumns();

        @Option(shortName={"d"}, longName={"data"}, description="the data")
        public String getDataColumn();

        @Option(shortName={"i"}, longName={"input"}, description="the input list file")
        public String getFile();

        @Option(shortName={"r"}, longName={"rows"}, description="the rows")
        public List<String> getRows();
    }
}

