/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.scripts;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class ToGct13 {
    public ToGct13(ToGct13Args args) throws IOException {
        int sheetIndex = 1;
        int sheetCount = ExcelReader.getSheetCount(args.getTag());
        if (sheetCount == 1) {
            sheetIndex = 0;
        }
        String[][] tagFileData = ((Array2DContentHandler)new ExcelReader(args.getTag(), sheetIndex, (ExcelReaderContentHandler)new Array2DContentHandler()).getContentHandler()).getData();
        String[] tagHeader = tagFileData[0];
        HashSet<String> tagHeaderNames = new HashSet<String>();
        for (String header : tagHeader) {
            if (tagHeaderNames.contains(header)) {
                System.err.println("Tag file " + args.getTag() + " contains duplicate header '" + header + "'.");
                System.exit(1);
            }
            tagHeaderNames.add(header);
        }
        Dataset dataset = ProjectIO.readProject(args.getGct()).getOriginalDataset();
        String[] header = tagFileData[0];
        Vector[] vectors = new Vector[header.length - 1];
        for (int j = 1; j < header.length; ++j) {
            vectors[j - 1] = dataset.getColumnMetadata().add(header[j], String.class);
        }
        List datasetColumnIds = VectorUtil.asList(dataset.getColumnMetadata().get(0));
        Map sampleNameToIndex = IOUtil.buildIndexMap(datasetColumnIds);
        int sampleNameTagColumnIndex = 0;
        if (args.isTagFileSampleIdColumn() && (sampleNameTagColumnIndex = Arrays.asList(tagFileData[0]).indexOf(args.getTagFileSampleIdColumn())) == -1) {
            System.err.println(args.getTagFileSampleIdColumn() + " not found in tag file. Headers are: " + Arrays.asList(tagFileData[0]));
            System.exit(1);
        }
        int length = tagFileData.length;
        for (int i = 1; i < length; ++i) {
            String sampleName = tagFileData[i][sampleNameTagColumnIndex];
            Integer columnIndex = sampleNameToIndex.get(sampleName);
            if (columnIndex == null) continue;
            for (int j = 1; j < header.length; ++j) {
                vectors[j - 1].setValue(columnIndex, tagFileData[i][j]);
            }
        }
        File dir = new File(args.isOutputDirectory() ? args.getOutputDirectory() : System.getProperty("user.dir"));
        dir.mkdirs();
        File outputFile = new File(dir, IOUtil.getBaseFileName(args.getGct()));
        ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", outputFile.getCanonicalPath(), true);
    }

    public static void main(String[] args) throws Exception {
        try {
            Cli cli = CliFactory.createCli(ToGct13Args.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            ToGct13Args argsp = (ToGct13Args)cli.parseArguments(args);
            new ToGct13(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    @CommandLineInterface(application="to_gct1.3")
    public static interface ToGct13Args {
        @Option(longName={"gct"}, shortName={"g"}, description="the gct file")
        public String getGct();

        @Option(longName={"output"}, shortName={"o"}, description="the output directory")
        public String getOutputDirectory();

        @Option(longName={"tag"}, shortName={"t"}, description="the GSE tag file")
        public String getTag();

        @Option(longName={"tag-sample-id"}, description="the column in the tag file containing the sample column id")
        public String getTagFileSampleIdColumn();

        public boolean isTagFileSampleIdColumn();

        public boolean isOutputDirectory();

        @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
        public boolean getHelp();
    }
}

