/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmap.smm;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideLabel;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.io.matrix.gpr.GprReader2;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class ImportSMMAction
extends AbstractAction {
    private static Map<String, BufferedImage> imageCache = Collections.synchronizedMap(new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
            return this.size() >= 50;
        }
    });
    private GENEEWindow dialog;
    private FileInputParameter gctFileInput;
    private FileInputParameter gprDirectoryInput;
    private FileInputParameter jpegDirectoryInput;

    public ImportSMMAction() {
        super("Import SMM\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.dialog = Application.createDialog("Import SMM");
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.nextRow();
            formBuilder.addLabel("GCT File:");
            this.gctFileInput = new FileInputParameter("", FileInputParameter.OPEN_FILE);
            formBuilder.add(this.gctFileInput);
            formBuilder.nextRow();
            formBuilder.addLabel("JPEG Directory:");
            this.jpegDirectoryInput = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY);
            formBuilder.add(this.jpegDirectoryInput);
            formBuilder.nextRow();
            formBuilder.addLabel("GPR Directory:");
            this.gprDirectoryInput = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY);
            formBuilder.add(this.gprDirectoryInput);
            formBuilder.nextRow();
            this.dialog.getContentPane().add(formBuilder.getPanel());
            this.dialog.getContentPane().add((Component)UIUtil.buildOKCancelBar(this.dialog, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportSMMAction.this.dialog.setVisible(false);
                    new MyBackgroundTask(ImportSMMAction.this.gctFileInput.getText().trim(), ImportSMMAction.this.gprDirectoryInput.getFile(), ImportSMMAction.this.jpegDirectoryInput.getFile()).execute();
                }
            }), "South");
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
    }

    private static BufferedImage[][] createImageMatrix(Project project, File gprDirectory, File jpegDirectory, int extraPixels) {
        int[] selectedColumnIndices = project.getColumnSelectionModel().getSelectedModelIndices();
        String[] gprFileNames = new String[selectedColumnIndices.length];
        Dataset d = project.getOriginalDataset();
        int length = selectedColumnIndices.length;
        for (int j = 0; j < length; ++j) {
            gprFileNames[j] = d.getColumnMetadata().get(0).getValue(selectedColumnIndices[j]).toString();
        }
        int[] selectedRowIndices = project.getRowSelectionModel().getSelectedModelIndices();
        String[] ids = new String[selectedRowIndices.length];
        final HashSet<String> idsSet = new HashSet<String>();
        int length2 = selectedRowIndices.length;
        for (int i = 0; i < length2; ++i) {
            ids[i] = d.getRowMetadata().get(0).getValue(selectedRowIndices[i]).toString();
            idsSet.add(ids[i]);
        }
        Point point = new Point();
        BufferedImage[][] jpegMatrix = new BufferedImage[selectedRowIndices.length][selectedColumnIndices.length];
        int cols = gprFileNames.length;
        for (int j = 0; j < cols; ++j) {
            GprReader2 gprReader = null;
            try {
                gprReader = new GprReader2(IOUtil.getPath(new File(gprDirectory, gprFileNames[j] + ".gpr"))){

                    @Override
                    protected boolean add(String id, GprReader2.GprValue val) {
                        if (idsSet.contains(id)) {
                            this.map.put(id, val);
                            if (this.map.size() == idsSet.size()) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read grp file " + gprFileNames[j] + ".gpr");
            }
            BufferedImage fullImage = imageCache.get(gprFileNames[j]);
            if (fullImage == null) {
                fullImage = ImageUtil.readImage(new File(jpegDirectory, gprFileNames[j] + "_R1.jpg"));
                imageCache.put(gprFileNames[j], fullImage);
            }
            int rows = ids.length;
            for (int i = 0; i < rows; ++i) {
                int diameter;
                GprReader2.GprValue value = gprReader.get(ids[i]);
                if (value == null) {
                    throw new NullPointerException("No entry for " + ids[i] + " in grp file " + gprFileNames[j] + ".gpr.");
                }
                ImportSMMAction.getCoordinates(gprReader, value, point);
                int w = diameter = value.getDiameter() / gprReader.getPixelSize();
                int h = diameter;
                if (extraPixels > 0) {
                    point.x -= extraPixels;
                    if (point.x < 0) {
                        point.x = 0;
                    }
                    point.y -= extraPixels;
                    if (point.y < 0) {
                        point.y = 0;
                    }
                    h += 2 * extraPixels;
                    if (point.x + (w += 2 * extraPixels) > fullImage.getWidth()) {
                        w = fullImage.getWidth() - point.x;
                    }
                    if (point.y + h > fullImage.getHeight()) {
                        h = fullImage.getHeight() - point.y;
                    }
                }
                jpegMatrix[i][j] = GraphicsUtilities.convertToBufferedImage((Image)fullImage.getSubimage(point.x, point.y, w, h));
            }
        }
        return jpegMatrix;
    }

    private static void getCoordinates(GprReader2 gpr, GprReader2.GprValue value, Point point) {
        int diameter = value.getDiameter() / gpr.getPixelSize();
        int radius = diameter / 2;
        int x = (value.getX() - gpr.getJpegOriginX()) / gpr.getPixelSize();
        int y = (value.getY() - gpr.getJpegOriginY()) / gpr.getPixelSize();
        point.x = x -= radius;
        point.y = y -= radius;
    }

    private static class MyBackgroundTask
    extends BackgroundTask<Project>
    implements GENEEWindowNotifier {
        private int additionalPixels = 0;
        private String gctFile;
        private File gprDirectory;
        private ImagePanel imagePanel;
        private File jpegDirectory;
        private Project project;
        private SelectionListener selectionListener;
        private boolean sync = true;
        private GENEEWindow viewWindow;

        public MyBackgroundTask(String gctFile, File gprDirectory, File jpegDirectory) {
            super("Importing " + new File(gctFile).getName());
            this.gctFile = gctFile;
            this.gprDirectory = gprDirectory;
            this.jpegDirectory = jpegDirectory;
            this.selectionListener = new SelectionListener(){

                @Override
                public void valueChanged(SelectionEvent e) {
                    if (MyBackgroundTask.this.sync) {
                        MyBackgroundTask.this.updateImages();
                    }
                }
            };
        }

        @Override
        public void notifyHidden() {
            this.project.getRowSelectionModel().removeSelectionListener(this.selectionListener);
            this.project.getColumnSelectionModel().removeSelectionListener(this.selectionListener);
        }

        @Override
        public void notifyShowing() {
        }

        @Override
        protected Project doInBackground() throws Exception {
            return ProjectIO.readProject(this.gctFile);
        }

        @Override
        protected void succeeded(Project p) {
            History history = new History("Import SMM");
            history.add("File", this.gctFile);
            ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(p, history, null);
            AbstractAction action = new AbstractAction("SMM Image Viewer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyBackgroundTask.this.project = Application.getProject();
                    MyBackgroundTask.this.project.getRowSelectionModel().addSelectionListener(MyBackgroundTask.this.selectionListener);
                    MyBackgroundTask.this.project.getColumnSelectionModel().addSelectionListener(MyBackgroundTask.this.selectionListener);
                    MyBackgroundTask.this.viewWindow = Application.createViewWindow("SMM Image Viewer", MyBackgroundTask.this);
                    MyBackgroundTask.this.imagePanel = new ImagePanel();
                    MyBackgroundTask.this.updateImages();
                    MyBackgroundTask.this.viewWindow.getContentPane().add(UIUtil.createNoBorderScrollPane(MyBackgroundTask.this.imagePanel));
                    FormBuilder formBuilder = new FormBuilder();
                    formBuilder.nextRow().nextRow();
                    formBuilder.addLabel("Number of additional neighboring pixels:");
                    final JTextField textField = new JTextField("0", 12);
                    textField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int tmp = ParserHelper.parseInt(textField.getText().trim());
                            if (tmp != MyBackgroundTask.this.additionalPixels) {
                                MyBackgroundTask.this.additionalPixels = tmp;
                                MyBackgroundTask.this.updateImages();
                            }
                        }
                    });
                    formBuilder.add(textField);
                    formBuilder.nextRow();
                    final JCheckBox syncCheckBox = new JCheckBox("Synchronize with heat map selection", true);
                    syncCheckBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MyBackgroundTask.this.sync = syncCheckBox.isSelected();
                            if (MyBackgroundTask.this.sync) {
                                MyBackgroundTask.this.updateImages();
                            }
                        }
                    });
                    formBuilder.addSpanned(syncCheckBox);
                    MyBackgroundTask.this.viewWindow.getContentPane().add((Component)formBuilder.getPanel(), "South");
                    MyBackgroundTask.this.viewWindow.pack();
                    MyBackgroundTask.this.viewWindow.setVisible(true);
                }
            };
            ((HeatMapPanel)node.getDisplayInfo().getComponent()).getRowPopupMenu().add(action);
            ((HeatMapPanel)node.getDisplayInfo().getComponent()).getColumnPopupMenu().add(action);
            Application.add(new GENEEFolderNode("Import SMM", history, node));
        }

        private void updateImages() {
            Dataset d = this.project.getOriginalDataset();
            int[] selectedColumnIndices = this.project.getColumnSelectionModel().getSelectedModelIndices();
            String[] columnNames = new String[selectedColumnIndices.length];
            int length = columnNames.length;
            for (int i = 0; i < length; ++i) {
                columnNames[i] = d.getColumnMetadata().get(0).getValue(selectedColumnIndices[i]).toString();
            }
            int[] selectedRowIndices = this.project.getRowSelectionModel().getSelectedModelIndices();
            String[] rowNames = new String[selectedRowIndices.length];
            int length2 = rowNames.length;
            for (int i = 0; i < length2; ++i) {
                rowNames[i] = d.getRowMetadata().get(0).getValue(selectedRowIndices[i]).toString();
            }
            this.imagePanel.setMatrix(ImportSMMAction.createImageMatrix(this.project, this.gprDirectory, this.jpegDirectory, this.additionalPixels), rowNames, columnNames);
        }
    }

    private static class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        private void setMatrix(BufferedImage[][] matrix, String[] rowNames, String[] columnNames) {
            this.removeAll();
            int rows = matrix.length;
            int cols = matrix[0].length;
            FormLayout formLayout = new FormLayout(UIUtil.createColumnStringForFormLayout("center:p", cols + 1), UIUtil.createColumnStringForFormLayout("center:p", rows + 1));
            CellConstraints cc = new CellConstraints();
            this.setLayout((LayoutManager)formLayout);
            int j = 0;
            int formCol = 1;
            while (j < cols) {
                JideLabel label = new JideLabel(columnNames[j]);
                label.setOrientation(1);
                label.setClockwise(false);
                this.add((Component)label, cc.xy(formCol, 1));
                ++j;
                formCol += 2;
            }
            int i = 0;
            int formRow = 3;
            while (i < rows) {
                int j2 = 0;
                int formCol2 = 1;
                while (j2 < cols) {
                    if (matrix[i][j2] != null) {
                        this.add((Component)new JLabel(new ImageIcon(matrix[i][j2])), cc.xy(formCol2, formRow));
                    }
                    ++j2;
                    formCol2 += 2;
                }
                this.add((Component)new JLabel(rowNames[i]), cc.xy(cols * 2 + 1, formRow));
                ++i;
                formRow += 2;
            }
            this.revalidate();
            this.repaint();
        }
    }
}

