/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.script.ScriptException;
import javax.swing.JLabel;
import org.broadinstitute.genee.cmdline.BasicCmdLineArgs;
import org.broadinstitute.genee.cmdline.CmdLineUtil;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.ToolRunner;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.heatmap.menu.CreateComputedVectorAction;
import org.broadinstitute.genee.heatmap.menu.VerticalDrawableArray;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class HeatMapImage {
    public HeatMapImage(HeatMapImageCmdLineArgs argsp) {
        UIUtil.standaloneInit();
        try {
            Dataset dataset = CmdLineUtil.read(argsp.getInputDataset(), argsp.getRowIds(), argsp.getColumnIds());
            HeatMapImage.createImage((Project)new DefaultProject(dataset), argsp);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void createImage(Project project, String[] args) throws Exception {
        Cli cli = CliFactory.createCli(HeatMapImageArgs.class);
        HeatMapImageArgs argsp = (HeatMapImageArgs)cli.parseArguments(args);
        HeatMapImage.createImage(project, argsp);
    }

    public static void main(String[] args) throws IOException {
        try {
            Cli cli = CliFactory.createCli(HeatMapImageCmdLineArgs.class);
            if (args.length == 0) {
                System.out.println(cli.getHelpMessage());
                System.exit(0);
            }
            HeatMapImageCmdLineArgs argsp = (HeatMapImageCmdLineArgs)cli.parseArguments(args);
            new HeatMapImage(argsp);
        }
        catch (ArgumentValidationException e) {
            System.err.println(e.getMessage());
        }
    }

    static void createImage(Project project, HeatMapImageArgs argsp) throws Exception {
        String sortRows;
        if (argsp.getAnnotateRows() != null) {
            new ExcelReader(argsp.getAnnotateRows(), new AddToMetadataContentHandler(project.getOriginalDataset().getRowMetadata(), project.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(project.getOriginalDataset().getRowMetadata().get(0)), true));
        }
        if (argsp.getAnnotateColumns() != null) {
            new ExcelReader(argsp.getAnnotateColumns(), new AddToMetadataContentHandler(project.getOriginalDataset().getColumnMetadata(), project.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(project.getOriginalDataset().getColumnMetadata().get(0)), false));
        }
        LinkedHashSet<String> reorderedRowFields = new LinkedHashSet<String>();
        if (argsp.getRowColorMetadataNames() != null) {
            reorderedRowFields.addAll(argsp.getRowColorMetadataNames());
        }
        if (argsp.getRowTextMetadataNames() != null) {
            reorderedRowFields.addAll(argsp.getRowTextMetadataNames());
        }
        TIntArrayList order = new TIntArrayList();
        for (String name : reorderedRowFields) {
            int index = project.getOriginalDataset().getRowMetadata().getColumnIndex(name);
            if (index == -1) continue;
            order.add(index);
        }
        final MetadataModelColumnView rowMetadata = new MetadataModelColumnView(project.getOriginalDataset().getRowMetadata(), order.toArray());
        LinkedHashSet<String> reorderedColumnFields = new LinkedHashSet<String>();
        if (argsp.getColumnColorMetadataNames() != null) {
            reorderedColumnFields.addAll(argsp.getColumnColorMetadataNames());
        }
        if (argsp.getColumnTextMetadataNames() != null) {
            reorderedColumnFields.addAll(argsp.getColumnTextMetadataNames());
        }
        order = new TIntArrayList();
        for (String name : reorderedColumnFields) {
            int index = project.getOriginalDataset().getColumnMetadata().getColumnIndex(name);
            if (index == -1) continue;
            order.add(index);
        }
        final MetadataModelColumnView columnMetadata = new MetadataModelColumnView(project.getOriginalDataset().getColumnMetadata(), order.toArray());
        project.setDataset(new DatasetAdapter(project.getOriginalDataset()){

            @Override
            public MetadataModel getColumnMetadata() {
                return columnMetadata;
            }

            @Override
            public MetadataModel getRowMetadata() {
                return rowMetadata;
            }
        });
        if (argsp.isClusterRows() || argsp.isClusterColumns()) {
            ToolRunner runner = new ToolRunner("Hierarchical Clustering", project);
            if (argsp.isClusterRows()) {
                runner.setParameterValue("Cluster rows", true);
                runner.setParameterValue("Row distance metric", argsp.getRowDistanceMetric());
            }
            if (argsp.isClusterColumns()) {
                runner.setParameterValue("Column distance metric", argsp.getColumnDistanceMetric());
            }
            runner.setParameterValue("Linkage method", argsp.getLinkageMethod());
            project = runner.execute()[0];
        }
        if ((sortRows = argsp.getSortRows()) != null) {
            Vector vector = project.getOriginalDataset().getRowMetadata().get(sortRows);
            if (vector == null) {
                try {
                    CreateComputedVectorAction.createComputedField(project, sortRows, sortRows, true, false);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                }
            }
            project.setRowSortOrder(Arrays.asList(new SortKeys.VectorSortKey(sortRows, SortOrder.DESCENDING, true)));
        }
        HeatMapPanel heatMapPanel = new HeatMapPanel(project);
        HeatMapImage.setProps(project.getOriginalDataset().getColumnMetadata(), "Color Visible", argsp.getColumnColorMetadataNames());
        HeatMapImage.setProps(project.getOriginalDataset().getRowMetadata(), "Color Visible", argsp.getRowColorMetadataNames());
        HeatMapImage.setProps(project.getOriginalDataset().getRowMetadata(), "Text Visible", argsp.getRowTextMetadataNames());
        HeatMapImage.setProps(project.getOriginalDataset().getColumnMetadata(), "Text Visible", argsp.getColumnTextMetadataNames());
        if (argsp.isGlobalColorScheme()) {
            heatMapPanel.getColorScheme().setRelative(false);
            heatMapPanel.getColorScheme().setGlobalMax(Float.parseFloat(argsp.getGlobalColorSchemeMax().replace("\\", "")));
            heatMapPanel.getColorScheme().setGlobalMin(Float.parseFloat(argsp.getGlobalColorSchemeMin().replace("\\", "")));
        }
        if (argsp.getStringColorScheme() != null) {
            String[] tokens = argsp.getStringColorScheme().trim().split(",");
            ArrayList<Color> colors = new ArrayList<Color>();
            TFloatArrayList values = new TFloatArrayList();
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (String token : tokens) {
                int index = (token = token.trim()).indexOf(58);
                if (index == -1) continue;
                String s = token.substring(0, index).replace("\"", "").replace("\\", "");
                float value = Float.parseFloat(s);
                String hex = token.substring(index + 1);
                values.add(value);
                min = Math.min(min, value);
                max = Math.max(max, value);
                colors.add(Color.decode("" + Integer.parseInt(hex.replace("#", ""), 16)));
            }
            heatMapPanel.getColorScheme().setRelative(false);
            heatMapPanel.getColorScheme().setGlobalMax(max);
            heatMapPanel.getColorScheme().setGlobalMin(min);
            float[] fractions = new float[values.size()];
            for (int i = 0; i < fractions.length; ++i) {
                float f;
                float value = values.getQuick(i);
                fractions[i] = f = (value - min) / (max - min);
            }
            heatMapPanel.getColorScheme().setColors(colors.toArray(new Color[0]), fractions);
        }
        heatMapPanel.setRowSize(argsp.getRowSize());
        heatMapPanel.setColumnSize(argsp.getColumnSize());
        String imageFile = argsp.getOutputFile();
        Drawable drawable = heatMapPanel;
        if (argsp.isTitle()) {
            JLabel label = new JLabel(argsp.getTitle());
            Dimension p = label.getPreferredSize();
            p.height += 10;
            label.setPreferredSize(p);
            drawable = new VerticalDrawableArray(new DrawableWrapper(label), heatMapPanel);
        }
        try {
            ImageUtil.saveImage(drawable, argsp.getOutputFileFormat(), new File(imageFile), true);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private static void setProps(MetadataModel model, Object key, List<String> names) {
        if (names != null) {
            int n = model.getMetadataCount();
            for (int i = 0; i < n; ++i) {
                Vector v = model.get(i);
                v.setProperty(key, names.contains(v.getName()));
            }
        }
    }

    @CommandLineInterface(application="heatmap")
    public static interface HeatMapImageCmdLineArgs
    extends BasicCmdLineArgs,
    HeatMapImageArgs {
    }

    public static interface HeatMapImageArgs {
        @Option(longName={"annotate-rows"}, description="file to annotate the rows of the dataset", defaultToNull=true)
        public String getAnnotateRows();

        @Option(longName={"annotate-columns"}, description="file to annotate the columns of the dataset", defaultToNull=true)
        public String getAnnotateColumns();

        @Option(longName={"column-color"}, description="the column metadata names to display as colors", defaultToNull=true)
        public List<String> getColumnColorMetadataNames();

        @Option(longName={"row-color"}, description="the row metadata names to display as colors", defaultToNull=true)
        public List<String> getRowColorMetadataNames();

        @Option(longName={"column-dist"}, description="the column distance metric. Default is One minus pearson correlation. Choices are: City-block distance, Euclidean distance, Kendall's tau, One minus pearson correlation, and One minus spearman rank correlation", defaultValue={"One minus pearson correlation"})
        public String getColumnDistanceMetric();

        @Option(longName={"column-size"}, description="the heat map column size", defaultValue={"12"})
        public float getColumnSize();

        @Option(longName={"column-text"}, description="the column metadata names to display as text", defaultToNull=true)
        public List<String> getColumnTextMetadataNames();

        @Option(longName={"linkage"}, description="the linkage method. Default is Average Linkage. Choices are: Average Linkage, Complete Linkage, and Single Linkage", defaultValue={"Average Linkage"})
        public String getLinkageMethod();

        @Option(shortName={"o"}, longName={"image-file"}, description="the output image file")
        public String getOutputFile();

        @Option(longName={"format"}, description="the output image file format (jpeg, png, tiff, bmp, pdf). Default is png", defaultValue={"png"})
        public String getOutputFileFormat();

        @Option(longName={"row-dist"}, description="the row distance metric. Default is One minus pearson correlation. See --column-dist for possible values.", defaultValue={"One minus pearson correlation"})
        public String getRowDistanceMetric();

        @Option(longName={"row-size"}, description="the heat map row size", defaultValue={"12"})
        public float getRowSize();

        @Option(longName={"row-text"}, description="the row metadata names to display as text", defaultToNull=true)
        public List<String> getRowTextMetadataNames();

        @Option(longName={"sort-rows"}, description="A function or a metadata name to sort the rows by", defaultToNull=true)
        public String getSortRows();

        @Option(longName={"title"}, description="the heat map title")
        public String getTitle();

        @Option(longName={"cluster-columns"}, description="cluster columns")
        public boolean isClusterColumns();

        @Option(longName={"cluster-rows"}, description="cluster rows")
        public boolean isClusterRows();

        public boolean isTitle();

        @Option(longName={"global-min"}, description="min value for global color scheme", defaultValue={"-10"})
        public String getGlobalColorSchemeMin();

        public boolean isGlobalColorSchemeMin();

        @Option(longName={"global-max"}, description="max value for global color scheme", defaultValue={"10"})
        public String getGlobalColorSchemeMax();

        public boolean isGlobalColorSchemeMax();

        @Option(longName={"global-color"}, description="use global color scheme")
        public boolean isGlobalColorScheme();

        @Option(longName={"color-scheme"}, description="string encoded color scheme of value:hex pairs (e.g. \"\\-100:#0000FF,\\-80:#FFFFFF,80:#FFFFFF,100:#FF0000)\"", defaultToNull=true)
        public String getStringColorScheme();
    }
}

