/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.io.File;
import org.broadinstitute.genee.gui.actions.ToolRunner;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HierarchicalClusteringExample {
    public static void main(String[] args) throws Exception {
        String file = "C:\\Users\\jgould\\Documents\\datasets\\all_aml_train.gct";
        Project project = ProjectIO.readProject(file);
        project.setDataset(DatasetUtil.sliceView(project.getOriginalDataset(), IOUtil.seqInt(10), null));
        Vector longTest = project.getOriginalDataset().getColumnMetadata().get(0);
        longTest.setValue(0, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAZZZZZZZZZZZZZZZZZXXXXXXXXXXAAAAAAAAAAAABBBBBBBBBBBBBBCCCCCCCCCCC");
        ToolRunner runner = new ToolRunner("Hierarchical Clustering", project);
        runner.setParameterValue("Column distance metric", "Euclidean distance");
        runner.setParameterValue("Cluster rows", "true");
        runner.setParameterValue("Row distance metric", "Euclidean distance");
        Project p = runner.execute()[0];
        ImageUtil.saveImage(new HeatMapPanel(p), "png", new File(IOUtil.getBaseFileName(file) + "-clustered"), true);
    }
}

