/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.genee.cmdline.MafConcat;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.MafHeader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class MafToGct
implements MafConcat {
    private List<String> sampleNames = new ArrayList<String>();
    private Map<Identifier, Set<String>> siteToSamples = new HashMap<Identifier, Set<String>>();

    @Override
    public synchronized void add(String mafFile) throws IOException {
        String[][] data = ((Array2DContentHandler)new ExcelReader(mafFile, new Array2DContentHandler()).getContentHandler()).getData();
        String sample = IOUtil.getBaseFileName(IOUtil.getBaseFileName(mafFile));
        this.sampleNames.add(sample);
        MafHeader header = new MafHeader(Arrays.asList(data[0]));
        if (header.Hugo_Symbol == -1) {
            throw new IOException("Hugo_Symbol not found in " + mafFile + ". Fields are " + Arrays.asList(data[0]));
        }
        if (header.Start_Position == -1) {
            throw new IOException("Start_Position not found in " + mafFile + ". Fields are " + Arrays.asList(data[0]));
        }
        if (header.Variant_Classification == -1) {
            throw new IOException("Variant_Classification not found in " + mafFile + ". Fields are " + Arrays.asList(data[0]));
        }
        for (int i = 1; i < data.length; ++i) {
            String[] row = data[i];
            Identifier<Object> id = new Identifier<Object>(row[header.Hugo_Symbol].trim(), row[header.Start_Position].trim(), row[header.Variant_Classification].trim());
            Set<String> samples = this.siteToSamples.get(id);
            if (samples == null) {
                samples = new HashSet<String>();
                this.siteToSamples.put(id, samples);
            }
            samples.add(sample);
        }
    }

    @Override
    public synchronized void save(String file) throws IOException {
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", this.siteToSamples.size(), this.sampleNames.size());
        System.out.println(file + " " + this.siteToSamples.size() + " sites");
        Vector sampleIdVector = dataset.getColumnMetadata().add("id", String.class);
        for (int i = 0; i < this.sampleNames.size(); ++i) {
            sampleIdVector.setValue(i, this.sampleNames.get(i));
        }
        Map idToIndex = VectorUtil.createValueToIndexMap(sampleIdVector);
        Vector gene = dataset.getRowMetadata().add("Hugo_Symbol", String.class);
        Vector Start_Position = dataset.getRowMetadata().add("Start_Position", String.class);
        Vector Variant_Classification = dataset.getRowMetadata().add("Variant_Classification", String.class);
        int rowIndex = 0;
        for (Identifier site : this.siteToSamples.keySet()) {
            Set<String> samples = this.siteToSamples.get(site);
            gene.setValue(rowIndex, site.get(0));
            Start_Position.setValue(rowIndex, site.get(1));
            Variant_Classification.setValue(rowIndex, site.get(2));
            for (String sample : samples) {
                dataset.setValue(rowIndex, idToIndex.get(sample), 1.0f);
            }
            ++rowIndex;
        }
        ProjectIO.writeProject((Project)new DefaultProject(dataset), "gct", file);
    }
}

