/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.cmdline;

import java.util.Set;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.matrix.gctx.GctxReader;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.util.ProjectIO;
import uk.co.flamingpenguin.jewel.cli.Cli;
import uk.co.flamingpenguin.jewel.cli.CliFactory;
import uk.co.flamingpenguin.jewel.cli.CommandLineInterface;
import uk.co.flamingpenguin.jewel.cli.Option;

public class SubsetGctx {
    public static void main(String[] args) throws Exception {
        Cli cli = CliFactory.createCli(SubsetGctxArgs.class);
        if (args.length == 0) {
            System.out.println(cli.getHelpMessage());
            System.exit(0);
        }
        SubsetGctxArgs argsp = (SubsetGctxArgs)cli.parseArguments(args);
        Set<String> columnIds = null;
        if (argsp.getColumnSpace() != null) {
            columnIds = GeneSetIO.readGeneSetMatrix(argsp.getColumnSpace()).get(0).getMembers();
        }
        Set<String> rowIds = null;
        if (argsp.getRowSpace() != null) {
            rowIds = GeneSetIO.readGeneSetMatrix(argsp.getRowSpace()).get(0).getMembers();
        }
        ProjectIO.writeProject((Project)new DefaultProject(GctxReader.read(argsp.getInput(), rowIds, columnIds)), "gctx", argsp.getOutputFile());
    }

    @CommandLineInterface(application="subset-gctx")
    public static interface SubsetGctxArgs {
        @Option(shortName={"o"}, longName={"output"}, description="the output file name")
        public String getOutputFile();

        @Option(shortName={"i"}, longName={"input"}, description="the input gctx")
        public String getInput();

        @Option(shortName={"columns"}, description="Subset of columns to keep", defaultValue={"/xchip/cogs/data/vdb/summly/sigspace_n69762.grp"})
        public String getColumnSpace();

        @Option(shortName={"rows"}, description="Subset of rows to keep", defaultValue={"/xchip/cogs/data/vdb/spaces/bing_n10638.grp"})
        public String getRowSpace();

        @Option(helpRequest=true, description="display help", shortName={"h"}, longName={"help"})
        public boolean getHelp();
    }
}

