/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.compound.CombinationIndex;
import org.broadinstitute.genee.gui.AbstractGenericInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.TextFieldInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class CombinationIndexAction
extends AbstractGenericInputAction<GENEEWindow> {
    private static final String SCALE_TO_UNTREATED = "Scale to untreated";
    private static final String RATIOS_TO_INCLUDE = "Ratios to include (comma separated)";

    public CombinationIndexAction() {
        super("Combination Index");
        this.addParameter(RATIOS_TO_INCLUDE, new TextFieldInputParameter("10"), true);
        this.addParameter(new HiddenInputLabel(SCALE_TO_UNTREATED), new CheckBoxParameter(SCALE_TO_UNTREATED, true), true);
    }

    @Override
    protected void succeeded(Map map, MutableTreeNode parentNode, GENEEWindow window) {
        window.pack();
        window.setVisible(true);
    }

    @Override
    protected GENEEWindow execute(Map inputMap, ProgressNotifier status) throws Exception {
        String s = (String)inputMap.get(RATIOS_TO_INCLUDE);
        s = s.trim();
        boolean scaleToUntreated = (Boolean)inputMap.get(SCALE_TO_UNTREATED);
        String[] tokens = s.split(",");
        float[] ratios = new float[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            ratios[i] = ParserHelper.parseFloat(tokens[i]);
        }
        Project p = Application.getProject();
        Dataset inputDataset = p.getSortedFilteredDataset();
        RowMajorArray2DDataset dataset = DatasetUtil.deepCopy(inputDataset);
        String drugOneMetadataName = "ABT concentration";
        String drugTwoMetadataName = "Triptolide concentration";
        if (scaleToUntreated) {
            int untreatedRowIndex = CombinationIndexAction.getUntreatedIndex(dataset, drugOneMetadataName, drugTwoMetadataName);
            for (int i = 0; i < dataset.getRowCount(); ++i) {
                if (i == untreatedRowIndex) continue;
                for (int j = 0; j < dataset.getColumnCount(); ++j) {
                    float d = dataset.getValue(i, j);
                    float fa = d / dataset.getValue(untreatedRowIndex, j);
                    fa = Math.min(1.0f, fa);
                    fa = Math.max(0.0f, fa);
                    dataset.setValue(i, j, 1.0f - fa);
                }
            }
            for (int j = 0; j < dataset.getColumnCount(); ++j) {
                dataset.setValue(untreatedRowIndex, j, 0.0f);
            }
            ProjectIO.writeProject((Project)new DefaultProject(dataset), "txt", "C:\\Documents and Settings\\jgould.GPE61-20F\\Desktop\\test-ch.xls", true);
        }
        String drugOneName = "ABT";
        String drugTwoName = "Triptolide";
        int[] drugOneAloneIndices = CombinationIndexAction.getZeroIndices(dataset, drugTwoMetadataName);
        int[] drugTwoAloneIndices = CombinationIndexAction.getZeroIndices(dataset, drugOneMetadataName);
        float[] dose1 = CombinationIndexAction.getDose(dataset, drugOneAloneIndices, drugOneMetadataName);
        float[] dose2 = CombinationIndexAction.getDose(dataset, drugTwoAloneIndices, drugTwoMetadataName);
        ArrayList<int[]> indicesForRatios = new ArrayList<int[]>();
        for (float r : ratios) {
            indicesForRatios.add(CombinationIndexAction.getIndicesForRatio(dataset, drugOneMetadataName, drugTwoMetadataName, r));
        }
        GENEEWindow window = Application.createViewWindow("CI");
        FormLayout fl = new FormLayout("p", "");
        JPanel panel = new JPanel((LayoutManager)fl);
        CellConstraints cc = new CellConstraints();
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            fl.appendRow(UIUtil.decodeRowSpec("p"));
            panel.add((Component)new JSeparator(), cc.xyw(1, fl.getRowCount(), fl.getColumnCount()));
            fl.appendRow(UIUtil.decodeRowSpec("p"));
            CombinationIndex.DefaultDrug drugOneAlone = new CombinationIndex.DefaultDrug(drugOneName);
            drugOneAlone.setDose(dose1);
            drugOneAlone.setFractionEffected(CombinationIndexAction.getFA(dataset, drugOneAloneIndices, j));
            CombinationIndex.DefaultDrug drugTwoAlone = new CombinationIndex.DefaultDrug(drugTwoName);
            drugTwoAlone.setDose(dose2);
            drugTwoAlone.setFractionEffected(CombinationIndexAction.getFA(dataset, drugTwoAloneIndices, j));
            for (int r = 0; r < indicesForRatios.size(); ++r) {
                CombinationIndex.DefaultDrug combinedDrug = new CombinationIndex.DefaultDrug(drugTwoName + "/" + drugOneName);
                combinedDrug.setDose(CombinationIndexAction.getDose(dataset, (int[])indicesForRatios.get(r), drugTwoMetadataName));
                combinedDrug.setFractionEffected(CombinationIndexAction.getFA(dataset, (int[])indicesForRatios.get(r), j));
                combinedDrug.setRatio(new float[]{1.0f, ratios[r]});
                CombinationIndex.MedianEffectResult medianEffectResult = CombinationIndex.computeMedianEffect(Arrays.asList(drugOneAlone, drugTwoAlone), combinedDrug);
            }
        }
        window.getContentPane().add(new JScrollPane(panel));
        return window;
    }

    private static float[] getDose(Dataset dataset, int[] rowIndices, String metadataName) {
        float[] dose = new float[rowIndices.length];
        int rows = rowIndices.length;
        for (int i = 0; i < rows; ++i) {
            dose[i] = ((Number)dataset.getRowMetadata().getValue(rowIndices[i], metadataName)).floatValue();
        }
        return dose;
    }

    private static float[] getFA(Dataset dataset, int[] rowIndices, int columnIndex) {
        float[] dose = new float[rowIndices.length];
        int rows = rowIndices.length;
        for (int i = 0; i < rows; ++i) {
            dose[i] = dataset.getValue(rowIndices[i], columnIndex);
        }
        return dose;
    }

    private static int[] getIndicesForRatio(Dataset dataset, String metadataNameOne, String metadataNameTwo, float ratio) {
        TIntArrayList indices = new TIntArrayList();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            float d1 = ((Float)dataset.getRowMetadata().getValue(i, metadataNameOne)).floatValue();
            float d2 = ((Float)dataset.getRowMetadata().getValue(i, metadataNameTwo)).floatValue();
            float test = d2 / d1;
            float diff = 0.001f;
            if (!(Math.abs(test - ratio) < diff)) continue;
            indices.add(i);
        }
        return indices.toArray();
    }

    private static int getUntreatedIndex(Dataset dataset, String m1, String m2) {
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            float d1 = ((Float)dataset.getRowMetadata().getValue(i, m1)).floatValue();
            float d2 = ((Float)dataset.getRowMetadata().getValue(i, m2)).floatValue();
            if (d1 != 0.0f || d2 != 0.0f) continue;
            return i;
        }
        return -1;
    }

    private static int[] getZeroIndices(Dataset dataset, String metadataName) {
        TIntArrayList drugTwoAloneIndices = new TIntArrayList();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            float d = ((Float)dataset.getRowMetadata().getValue(i, metadataName)).floatValue();
            if (d != 0.0f) continue;
            drugTwoAloneIndices.add(i);
        }
        return drugTwoAloneIndices.toArray();
    }
}

