/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.math.stat.function.bivariate.PearsonCorrelation;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetSeriesRowView;

public class ComboDistance
implements DistanceFunction {
    private DistanceFunction ic50DistanceFunction = new Correlation();
    private int minSlopeSeriesIndex;
    private boolean useic50 = true;
    private boolean useSlope = true;
    private boolean useVMax = true;
    private BivariateFloatListFunction function = new PearsonCorrelation();
    private int vMaxSeriesIndex;
    private boolean l2Norm = false;

    public ComboDistance(int minSlopeSeriesIndex, int vMaxSeriesIndex) {
        this.minSlopeSeriesIndex = minSlopeSeriesIndex;
        this.vMaxSeriesIndex = vMaxSeriesIndex;
    }

    @Override
    public float evaluate(Dataset dataset, float[] weight, int index1, int index2) {
        DatasetSeriesRowView rowView1 = new DatasetSeriesRowView(dataset, null, this.vMaxSeriesIndex);
        DatasetSeriesRowView rowView2 = new DatasetSeriesRowView(dataset, null, this.vMaxSeriesIndex);
        float ic50Dist = this.ic50DistanceFunction.evaluate(dataset, weight, index1, index2);
        rowView1.setIndex(index1);
        rowView2.setIndex(index2);
        float vMaxDist = 1.0f - this.function.evaluate(rowView1, rowView2);
        rowView1.setSeriesIndex(this.minSlopeSeriesIndex);
        rowView2.setSeriesIndex(this.minSlopeSeriesIndex);
        float slopeDist = 1.0f - this.function.evaluate(rowView1, rowView2);
        float sum = 0.0f;
        int n = 0;
        if (this.useic50 && !Float.isNaN(ic50Dist)) {
            sum += this.l2Norm ? ic50Dist * ic50Dist : ic50Dist;
            ++n;
        }
        if (this.useVMax && !Float.isNaN(vMaxDist)) {
            sum += this.l2Norm ? vMaxDist * vMaxDist : vMaxDist;
            ++n;
        }
        if (this.useSlope && !Float.isNaN(slopeDist)) {
            sum += this.l2Norm ? slopeDist * slopeDist : slopeDist;
            ++n;
        }
        if (Float.isNaN(sum)) {
            return 0.0f;
        }
        float value = (float)(this.l2Norm ? Math.sqrt(sum) : (double)(sum / (float)n));
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return value;
    }

    public boolean isScaleToOne() {
        return false;
    }

    public ComboDistance setUseIc50(boolean b) {
        this.useic50 = b;
        return this;
    }

    public ComboDistance setUseSlope(boolean b) {
        this.useSlope = b;
        return this;
    }

    public ComboDistance setUseVMax(boolean b) {
        this.useVMax = b;
        return this;
    }
}

