/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import java.io.Serializable;
import java.util.AbstractMap;
import org.broadinstitute.genee.io.util.ParserHelper;

public class MolarConcentration
implements Comparable<MolarConcentration>,
Serializable {
    private float concentration;
    private String text;
    private static AbstractMap.SimpleEntry<String, Float>[] CONCS = new AbstractMap.SimpleEntry[]{new AbstractMap.SimpleEntry<String, Float>("mm", Float.valueOf(10000.0f)), new AbstractMap.SimpleEntry<String, Float>("um", Float.valueOf(1.0E7f)), new AbstractMap.SimpleEntry<String, Float>("\u00b5m", Float.valueOf(1.0E7f)), new AbstractMap.SimpleEntry<String, Float>("nm", Float.valueOf(1.0E10f)), new AbstractMap.SimpleEntry<String, Float>("pm", Float.valueOf(1.0E13f)), new AbstractMap.SimpleEntry<String, Float>("fm", Float.valueOf(1.0E16f)), new AbstractMap.SimpleEntry<String, Float>("am", Float.valueOf(1.0E19f)), new AbstractMap.SimpleEntry<String, Float>("zm", Float.valueOf(1.0E22f)), new AbstractMap.SimpleEntry<String, Float>("ym", Float.valueOf(1.0E25f)), new AbstractMap.SimpleEntry<String, Float>("m", Float.valueOf(1.0f))};

    public MolarConcentration(float concentration, String text) {
        this.concentration = concentration;
        this.text = text;
    }

    @Override
    public int compareTo(MolarConcentration o) {
        return Float.compare(this.concentration, o.concentration);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MolarConcentration) {
            return this.text.equals(((MolarConcentration)obj).text);
        }
        return false;
    }

    public float getConcentration() {
        return 1000000.0f * this.concentration;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        return this.text;
    }

    public static MolarConcentration parse(String text) {
        String s = text;
        if (s == null || s.equals("")) {
            return null;
        }
        s = s.toLowerCase();
        for (AbstractMap.SimpleEntry<String, Float> e : CONCS) {
            int index = s.indexOf(e.getKey());
            if (index == -1) continue;
            String value = s.substring(0, index);
            try {
                float conc = ParserHelper.parseFloat(value);
                return new MolarConcentration(conc /= e.getValue().floatValue(), text);
            }
            catch (NumberFormatException nfe) {
                return new MolarConcentration(0.0f, text);
            }
        }
        try {
            return new MolarConcentration(ParserHelper.parseFloat(s), text);
        }
        catch (NumberFormatException nfe) {
            return new MolarConcentration(0.0f, text);
        }
    }
}

