/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import chemaxon.struc.Molecule;
import java.io.File;
import java.util.List;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.HCLClusterHelper;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.TanimotoDistanceFunction;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class MoleculeClusterHelper {
    private Dataset dataset;
    private Dendrogram dendrogram;
    private RowMajorArray2DDataset inputDataset;
    private List<Molecule> molecules;

    public MoleculeClusterHelper(List<Molecule> molecules) {
        this.inputDataset = new RowMajorArray2DDataset("", molecules.size(), 1);
        this.inputDataset.getRowMetadata().add("smile", Molecule.class);
        this.molecules = molecules;
        int size = molecules.size();
        for (int i = 0; i < size; ++i) {
            Molecule m = molecules.get(i);
            String name = m.getName();
            if (name == null || name.equals("")) {
                name = (String)m.getPropertyObject("chemical_name");
            }
            if (name == null) {
                name = m.getFormula();
            }
            this.inputDataset.getRowMetadata().setValue(i, "smile", (Object)m);
        }
    }

    public void cluster() {
        RowMajorArray2DDataset distanceMatrixDataset = new RowMajorArray2DDataset("Distance Matrix", this.inputDataset.getRowCount(), this.inputDataset.getRowCount());
        try {
            MoleculeUtil.fillDistanceMatrix(this.inputDataset, distanceMatrixDataset, new TanimotoDistanceFunction("smile"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("Error computing tanimoto");
        }
        HCLClusterHelper clusterHelper = new HCLClusterHelper(distanceMatrixDataset, new Correlation(), null, LinkageMethod.AVERAGE_LINKAGE, null, null, null);
        int[] order = clusterHelper.getRowOrder();
        this.dendrogram = clusterHelper.getRowDendrogram();
        distanceMatrixDataset.getRowMetadata().add("Molecule", Molecule.class);
        int nrows = distanceMatrixDataset.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            distanceMatrixDataset.getRowMetadata().setValue(i, "Molecule", (Object)this.molecules.get(i));
        }
        this.dataset = DatasetUtil.sliceView(distanceMatrixDataset, order, order);
    }

    public Dendrogram getDendrogram() {
        return this.dendrogram;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public static void main(String[] args) throws Exception {
        UIUtil.standaloneInit();
        List<Molecule> molecules = MoleculeUtil.read(new File("test_files/test.sdf"));
        MoleculeClusterHelper hcl = new MoleculeClusterHelper(molecules);
        hcl.cluster();
        Dataset dataset = hcl.getDataset();
        DefaultProject project = new DefaultProject(dataset);
        project.setColumnDendrogram(hcl.getDendrogram());
        project.setRowDendrogram(hcl.getDendrogram());
        HeatMapPanel heatMapPanel = new HeatMapPanel(project);
        UIUtil.showInFrame(heatMapPanel);
    }
}

