/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.broadinstitute.genee.compound.CombinationIndex;
import org.broadinstitute.genee.io.excel.Array2DContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.ParserHelper;

public class TestCombinationIndex {
    private static void showGui(List<CombinationIndex.MedianEffect> individualEffects, CombinationIndex.MedianEffect comboEffect, boolean mutuallyExclusive) {
    }

    private static void test1() {
        CombinationIndex.MedianEffect ribose = new CombinationIndex.MedianEffect(new CombinationIndex.DefaultDrug("ribose"), 156.1f, 0.968f, 0.0f, 0.0f);
        CombinationIndex.MedianEffect adp = new CombinationIndex.MedianEffect(new CombinationIndex.DefaultDrug("adp"), 1.657f, 1.043f, 0.0f, 0.0f);
        CombinationIndex.DefaultDrug mixDrug = new CombinationIndex.DefaultDrug("mix");
        mixDrug.setRatio(new float[]{190.0f, 1.0f});
        CombinationIndex.MedianEffect mix = new CombinationIndex.MedianEffect(mixDrug, 107.0f, 1.004f, 0.0f, 0.0f);
        float ci = CombinationIndex.getCI(0.9f, Arrays.asList(ribose, adp), mix, true);
        System.out.println(ci);
    }

    private static void test2() throws Exception {
        String[][] data = ((Array2DContentHandler)new ExcelReader("C:\\Documents and Settings\\jgould.GPE61-20F\\Desktop\\test.xls", new Array2DContentHandler()).getContentHandler()).getData();
        LinkedHashMap<String, CombinationIndex.TmpDrug> drugToTreatment = new LinkedHashMap<String, CombinationIndex.TmpDrug>();
        for (int i = 1; i < data.length; ++i) {
            String drug = data[i][0];
            CombinationIndex.TmpDrug t = (CombinationIndex.TmpDrug)drugToTreatment.get(drug);
            if (t == null) {
                t = new CombinationIndex.TmpDrug();
                t.setDrugName(drug);
                drugToTreatment.put(drug, t);
            }
            t.add(ParserHelper.parseFloat(data[i][1]), ParserHelper.parseFloat(data[i][2]));
        }
        ArrayList<CombinationIndex.Drug> individualDrugs = new ArrayList<CombinationIndex.Drug>();
        for (CombinationIndex.TmpDrug t : drugToTreatment.values()) {
            individualDrugs.add(t.createDrug());
        }
        CombinationIndex.DefaultDrug combinedDrug = (CombinationIndex.DefaultDrug)individualDrugs.remove(individualDrugs.size() - 1);
        CombinationIndex.MedianEffectResult medianEffectResult = CombinationIndex.computeMedianEffect(individualDrugs, combinedDrug);
        for (CombinationIndex.MedianEffect m : medianEffectResult.individualEffects) {
            System.out.println(m);
        }
        System.out.println(medianEffectResult.comboEffect);
        float ci = CombinationIndex.getCI(0.45f, medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
        System.out.println(".45 = " + ci);
        ci = CombinationIndex.getCI(0.701f, medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
        System.out.println("0.701 = " + ci);
        ci = CombinationIndex.getCI(0.91f, medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
        System.out.println(".0.9100 = " + ci);
        ci = CombinationIndex.getCI(0.968f, medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
        System.out.println("0.968 = " + ci);
        ci = CombinationIndex.getCI(0.5f, medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
        System.out.println(".5 = " + ci);
        TestCombinationIndex.showGui(medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
    }

    private static void testTable2() {
        CombinationIndex.DefaultDrug fiveFu = new CombinationIndex.DefaultDrug("fivefu");
        fiveFu.setDose(new float[]{4.0f, 8.0f, 16.0f, 32.0f, 64.0f, 128.0f, 256.0f});
        fiveFu.setFractionEffected(new float[]{0.348f, 0.475f, 0.661f, 0.827f, 0.923f, 0.966f, 0.985f});
        CombinationIndex.DefaultDrug hu = new CombinationIndex.DefaultDrug("hu");
        hu.setDose(new float[]{50.0f, 100.0f, 200.0f, 400.0f, 800.0f, 1600.0f, 3200.0f});
        hu.setFractionEffected(new float[]{0.605f, 0.741f, 0.889f, 0.962f, 0.984f, 0.99f, 0.994f});
        CombinationIndex.DefaultDrug mix = new CombinationIndex.DefaultDrug("mix");
        mix.setDose(hu.getDose());
        mix.setFractionEffected(new float[]{0.208f, 0.168f, 0.345f, 0.747f, 0.885f, 0.957f, 0.977f});
        mix.setRatio(new float[]{1.0f, 12.5f});
        CombinationIndex.MedianEffectResult medianEffectResult = CombinationIndex.computeMedianEffect(Arrays.asList(fiveFu, hu), mix);
        for (CombinationIndex.MedianEffect m : medianEffectResult.individualEffects) {
        }
        for (int i = 0; i < 1; ++i) {
            float ci = CombinationIndex.getCI(0.05f * (float)(i + 1), medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
            System.out.println(0.05 * (double)(i + 1) + " = " + ci);
        }
        float fiveFuD = 8.039f;
        float fiveFuM = 1.187f;
        float huD = 34.09f;
        float huM = 1.196f;
        float mixD = 225.8f;
        float mixM = 1.407f;
        float ci = CombinationIndex.getCI(0.05f, new float[]{fiveFuD, huD}, new float[]{fiveFuM, huM}, mixD, mixM, new float[]{1.0f, 12.5f}, true);
        System.out.println("Paper 0.05 - " + ci);
        TestCombinationIndex.showGui(medianEffectResult.individualEffects, medianEffectResult.comboEffect, true);
    }

    public static void test4() {
        float pac = 0.00217f;
        float pacM = 1.24783f;
        float cis = 0.32016f;
        float cisM = 1.4599f;
        float com = 0.11471f;
        com = 0.00115f;
        float m = 1.5716f;
        float ci = CombinationIndex.getCI(0.45f, new float[]{pac, cis}, new float[]{pacM, cisM}, com, m, new float[]{100.0f, 1.0f}, true);
        System.out.println(ci);
    }

    private static void test3() {
        CombinationIndex.MedianEffect ph = new CombinationIndex.MedianEffect(new CombinationIndex.DefaultDrug("Phen"), 36.81f, 1.303f, 0.0f, 0.0f);
        CombinationIndex.MedianEffect adp = new CombinationIndex.MedianEffect(new CombinationIndex.DefaultDrug("adp"), 1.187f, 1.187f, 0.0f, 0.0f);
        CombinationIndex.DefaultDrug mixDrug = new CombinationIndex.DefaultDrug("mix");
        mixDrug.setRatio(new float[]{17.4f, 1.0f});
        CombinationIndex.MedianEffect mix = new CombinationIndex.MedianEffect(mixDrug, 9.116f, 1.742f, 0.0f, 0.0f);
        TestCombinationIndex.showGui(Arrays.asList(ph, adp), mix, false);
    }

    public static void main(String[] args) throws Exception {
        TestCombinationIndex.testTable2();
    }
}

