/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.broadinstitute.genee.compound.painter.ImageSupplier;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class DefaultImageSupplier
implements ImageSupplier {
    private LinkedHashMap<File, BufferedImage> fullSizeCache = new LinkedHashMap<File, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, BufferedImage> entry) {
            return this.size() >= 3000;
        }
    };
    private LinkedHashMap<FileAndSizeKey, BufferedImage> currentSizeCache = new LinkedHashMap<FileAndSizeKey, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<FileAndSizeKey, BufferedImage> entry) {
            return this.size() >= 2304;
        }
    };
    private boolean useThumb = false;
    private int currentWidth;
    private int currentHeight;

    @Override
    public Image getImage(File imageFile, int width, int height) {
        if (width != this.currentWidth || height != this.currentHeight) {
            this.currentWidth = width;
            this.currentHeight = height;
            this.currentSizeCache.clear();
        }
        if (this.useThumb) {
            return this.getThumbImage(imageFile, width, height);
        }
        try {
            BufferedImage image = this.currentSizeCache.get(imageFile);
            if (image == null) {
                image = this.fullSizeCache.get(imageFile);
            }
            if (image == null) {
                if (imageFile.exists()) {
                    image = ImageUtil.readImage(imageFile);
                }
                this.fullSizeCache.put(imageFile, image);
            }
            if (image.getWidth() != width || image.getHeight() != height) {
                image = GraphicsUtilities.createThumbnail((BufferedImage)image, (int)width, (int)height);
                this.currentSizeCache.put(new FileAndSizeKey(imageFile, width, height), image);
            }
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage createThumbnail(File fullSizeImageFile, File thumbnailFile, Dimension thumbSize) throws Exception {
        if (thumbnailFile.exists()) {
            return ImageUtil.readImage(thumbnailFile);
        }
        BufferedImage fullSizeImage = ImageUtil.readImage(fullSizeImageFile);
        if (fullSizeImage != null) {
            int h;
            int w;
            BufferedImage thumb;
            if (thumbSize == null) {
                thumbSize = DefaultImageSupplier.getThumbSize(fullSizeImage);
            }
            if ((thumb = GraphicsUtilities.createThumbnail((BufferedImage)fullSizeImage, (int)(w = thumbSize.width), (int)(h = thumbSize.height))) != null) {
                ImageIO.write((RenderedImage)thumb, "jpeg", thumbnailFile);
            } else {
                System.err.println("Unable to create thumbnail for " + fullSizeImageFile);
            }
            return thumb;
        }
        return null;
    }

    private Image getThumbImage(File f, int width, int height) {
        try {
            File imageFile = new File(f.getParentFile(), DefaultImageSupplier.getThumbImageName(f));
            BufferedImage image = this.fullSizeCache.get(imageFile);
            if (image == null) {
                image = imageFile.exists() ? ImageIO.read(imageFile) : DefaultImageSupplier.createThumbnail(f, imageFile, null);
                this.fullSizeCache.put(imageFile, image);
            }
            if (image.getWidth() != width || image.getHeight() != height) {
                image = GraphicsUtilities.createThumbnail((BufferedImage)image, (int)width, (int)height);
            }
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Dimension getThumbSize(BufferedImage image) {
        Dimension thumbSize = new Dimension();
        int width = image.getWidth();
        int factor = (int)Math.round((double)width / 150.0);
        if (factor < 1) {
            factor = 1;
        }
        thumbSize.width = width / factor;
        thumbSize.height = image.getHeight() / factor;
        if (thumbSize.width <= 0 || thumbSize.height <= 0) {
            throw new RuntimeException("Illegal thumnail. Original size is " + image.getWidth() + " x " + image.getHeight() + ". Scale factor is " + factor + ".");
        }
        return thumbSize;
    }

    private static String getThumbImageName(File file) {
        return IOUtil.getBaseFileName(file) + "-thumb.jpg";
    }

    private static class FileAndSizeKey {
        private File file;
        private int width;
        private int height;

        public FileAndSizeKey(File file, int width, int height) {
            this.file = file;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileAndSizeKey other = (FileAndSizeKey)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            return this.width == other.width;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + this.height;
            result = 31 * result + this.width;
            return result;
        }
    }
}

