/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.broadinstitute.genee.compound.painter.AddMetadataPanel;
import org.broadinstitute.genee.compound.painter.DefaultImageSupplier;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class ImageTypePanel
extends JPanel {
    private static final String DEFAULT_PATTERN = "^(?<Plate>.*)_(?<ExtraText>.*)(?<Well>[A-P][0-9][0-9])_(?<WellNumber>[0-9]+)";
    public static final String[] IMAGE_EXTENSIONS = new String[]{"jpg", "jpeg", "tiff", "tif", "gif", "png", "bmp"};
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<(\\w+)>");
    private static final int TEXT_FIELD_SIZE = 40;
    private AddMetadataPanel addMetadataPanel;
    private FileInputParameter fileInputPanel;
    private JComboBox fileNameMetadataSeparatorCharComboBox;
    private File imageDirectory;
    private File[] imageFiles;
    private String imageTypeName;
    private JTextField imageTypeNameTextField;
    private Map<String, Map<Comparable, List<File>>> metadataNameToValueToFiles;
    private char metadataSeparatorChar;
    private Pattern pattern;
    private List<String> patternGroupNames;
    private HashMap<String, Integer> patternGroupNameToIndex;
    private String regex;
    private boolean searchRecursively;
    private JLabel regularExpressionLabel;
    private JTextField regularExpressionTextField;
    private JCheckBox searchSubdirectoriesCheckBox;
    private String textImagesHaveInCommon;
    private JTextField textImagesHaveInCommonTextField;
    private Dimension thumbSize;
    private boolean userSuppliedRegex = false;
    private JLabel characterSeparatorLabel;
    private JRadioButton useRegularExpressionButton;
    private JRadioButton useSeparatorButton;

    ImageTypePanel() {
        this((ImageTypePanel)null);
    }

    ImageTypePanel(ImageTypePanel imageTypePanel) {
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Image type name:");
        this.imageTypeNameTextField = new JTextField(40);
        this.imageTypeNameTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ImageTypePanel.this.textImagesHaveInCommonTextField.getText().equals("")) {
                    ImageTypePanel.this.textImagesHaveInCommonTextField.setText(ImageTypePanel.this.imageTypeNameTextField.getText());
                }
            }
        });
        formBuilder.add(this.imageTypeNameTextField);
        formBuilder.nextRow();
        formBuilder.addLabel("Text that image file names have in common:");
        this.textImagesHaveInCommonTextField = new JTextField(40);
        formBuilder.add(this.textImagesHaveInCommonTextField);
        formBuilder.nextRow();
        formBuilder.addLabel("Specify metadata:");
        ButtonGroupHelper bg = new ButtonGroupHelper();
        this.useSeparatorButton = bg.createRadioButton("Using a separator", true);
        formBuilder.add(this.useSeparatorButton);
        this.useRegularExpressionButton = bg.createRadioButton("Using a regular expression", false);
        formBuilder.nextSmallRow();
        formBuilder.add(this.useRegularExpressionButton);
        formBuilder.nextRow();
        bg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageTypePanel.this.userSuppliedRegex = ImageTypePanel.this.useRegularExpressionButton.isSelected();
                ImageTypePanel.this.setUserSuppliedRegexVisibility();
            }
        });
        this.fileNameMetadataSeparatorCharComboBox = UIUtil.createComboBox(new Character[]{Character.valueOf('_'), Character.valueOf('-'), Character.valueOf(';'), Character.valueOf(',')});
        this.fileNameMetadataSeparatorCharComboBox.setSelectedIndex(0);
        this.characterSeparatorLabel = formBuilder.addLabel("Metadata in image file names is separated by:");
        formBuilder.add(this.fileNameMetadataSeparatorCharComboBox);
        formBuilder.nextRow();
        this.addMetadataPanel = new AddMetadataPanel();
        formBuilder.addSpanned(this.addMetadataPanel);
        formBuilder.nextRowNoSpace();
        this.regularExpressionLabel = formBuilder.addLabel("Regular expression to extract metadata:");
        this.regularExpressionLabel.setVisible(false);
        this.regularExpressionTextField = new JTextField(40);
        this.regularExpressionTextField.setVisible(false);
        this.regularExpressionTextField.setText(DEFAULT_PATTERN);
        formBuilder.add(this.regularExpressionTextField);
        formBuilder.nextRow();
        formBuilder.addLabel("Images location:");
        this.fileInputPanel = new FileInputParameter("", FileInputParameter.OPEN_DIRECTORY, 40);
        formBuilder.add(this.fileInputPanel);
        formBuilder.nextRow();
        this.searchSubdirectoriesCheckBox = new JCheckBox("Search image location sub-directories", true);
        formBuilder.addSpanned(this.searchSubdirectoriesCheckBox);
        this.setLayout(new BorderLayout());
        this.add(formBuilder.getPanel());
        if (imageTypePanel != null) {
            this.fileInputPanel.getTextField().setText(imageTypePanel.fileInputPanel.getText());
            DefaultListModel listModel = (DefaultListModel)this.addMetadataPanel.list.getModel();
            listModel.clear();
            int size = imageTypePanel.addMetadataPanel.list.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                listModel.addElement(imageTypePanel.addMetadataPanel.list.getModel().getElementAt(i));
            }
        }
    }

    public boolean containsGroup(String name) {
        return this.patternGroupNameToIndex.containsKey(name);
    }

    public void findFiles(ProgressNotifier progressMonitor) throws InterruptedException {
        this.imageFiles = this.listFiles(progressMonitor);
        if (this.imageFiles.length == 0) {
            throw new RuntimeException("No images found for " + this.getImageTypeName() + ".");
        }
        progressMonitor.setPercentComplete(20.0f);
        int nfiles = this.imageFiles.length;
        for (int j = 0; j < nfiles; ++j) {
            File file = this.imageFiles[j];
            progressMonitor.setPercentComplete(((float)j + 1.0f) / (float)(nfiles + 1));
            Matcher matcher = this.pattern.matcher(this.getFileName(file));
            if (!matcher.find()) continue;
            int ngroups = this.patternGroupNames.size();
            for (int i = 0; i < ngroups; ++i) {
                String value;
                String group = this.patternGroupNames.get(i);
                Map<Comparable, List<File>> valueToFiles = this.metadataNameToValueToFiles.get(group);
                List<File> files = valueToFiles.get(value = matcher.group(i + 1));
                if (files == null) {
                    files = new ArrayList<File>();
                    valueToFiles.put((Comparable)((Object)value), files);
                }
                files.add(file);
            }
        }
        for (String field : this.metadataNameToValueToFiles.keySet()) {
            try {
                Map<Comparable, List<File>> valueToFiles = this.metadataNameToValueToFiles.get(field);
                boolean nonNaN = false;
                TreeMap<Float, List<File>> newValueToFiles = new TreeMap<Float, List<File>>();
                for (Comparable stringValue : valueToFiles.keySet()) {
                    if (stringValue == null) continue;
                    float floatValue = ParserHelper.parseFloatNaN((String)((Object)stringValue));
                    if (!Float.isNaN(floatValue)) {
                        nonNaN = true;
                    }
                    newValueToFiles.put(Float.valueOf(floatValue), valueToFiles.get(stringValue));
                }
                if (!nonNaN) continue;
                this.metadataNameToValueToFiles.put(field, newValueToFiles);
            }
            catch (Throwable t) {}
        }
    }

    public Comparable getValue(File file, String name) {
        Integer index = this.patternGroupNameToIndex.get(name);
        if (index == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(this.getFileName(file));
        if (matcher.find()) {
            String val = matcher.group(index + 1);
            return val;
        }
        return null;
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public File[] getImageFiles() {
        return this.imageFiles;
    }

    public String getImageTypeName() {
        return this.imageTypeName;
    }

    public Map<String, Map<Comparable, List<File>>> getMetadataNameToValueToFiles() {
        return this.metadataNameToValueToFiles;
    }

    public char getMetadataSeparatorChar() {
        return this.metadataSeparatorChar;
    }

    public List<String> getPatternGroupNames() {
        return this.patternGroupNames;
    }

    public String getTextImagesHaveInCommon() {
        return this.textImagesHaveInCommon;
    }

    public Dimension getThumbSize() {
        if (this.thumbSize == null) {
            BufferedImage image = ImageUtil.readImage(this.imageFiles[0]);
            this.thumbSize = DefaultImageSupplier.getThumbSize(image);
        }
        return this.thumbSize;
    }

    public String getUserRegularExpression() {
        return this.regularExpressionTextField.getText().trim();
    }

    public String getWell(File file) {
        return (String)((Object)this.getValue(file, "Well"));
    }

    public boolean isRecursive() {
        return this.searchRecursively;
    }

    public boolean isUserSuppliedRegex() {
        return this.userSuppliedRegex;
    }

    public File[] listFiles(ProgressNotifier progressMonitor) throws InterruptedException {
        return IOUtil.listFiles(this.imageDirectory, new ImageFileFilter(this.textImagesHaveInCommon), null, progressMonitor, this.searchRecursively);
    }

    public void setImageDirectory(String imageDirectory) {
        this.fileInputPanel.getTextField().setText(imageDirectory);
    }

    public void setImageTypeName(String imageTypeName) {
        this.imageTypeNameTextField.setText(imageTypeName);
    }

    public void setMetadataSeparatorChar(char metadataSeparatorChar) {
        this.fileNameMetadataSeparatorCharComboBox.setSelectedItem(Character.valueOf(metadataSeparatorChar));
    }

    public void setPatternGroupNames(List<String> patternGroupNames) {
        DefaultListModel listModel = (DefaultListModel)this.addMetadataPanel.list.getModel();
        listModel.clear();
        int size = patternGroupNames.size();
        for (int i = 0; i < size; ++i) {
            listModel.addElement(patternGroupNames.get(i));
        }
    }

    public void setSearchRecursively(boolean searchRecursively) {
        this.searchSubdirectoriesCheckBox.setSelected(searchRecursively);
    }

    public void setTextImagesHaveInCommon(String textImagesHaveInCommon) {
        this.textImagesHaveInCommonTextField.setText(textImagesHaveInCommon);
    }

    public void setUserRegularExpression(String regex) {
        this.regularExpressionTextField.setText(regex);
    }

    public void setUserSuppliedRegex(boolean userSuppliedRegex) {
        this.userSuppliedRegex = userSuppliedRegex;
        if (userSuppliedRegex) {
            this.useRegularExpressionButton.setSelected(true);
        } else {
            this.useSeparatorButton.setSelected(true);
        }
        this.setUserSuppliedRegexVisibility();
    }

    public void updateValues() {
        this.textImagesHaveInCommon = this.textImagesHaveInCommonTextField.getText().trim();
        File[] tmp = this.fileInputPanel.getFiles();
        this.searchRecursively = this.searchSubdirectoriesCheckBox.isSelected();
        if (tmp.length == 0) {
            UIUtil.showErrorDialog(this, "Please supply an image location");
            throw new RuntimeException();
        }
        this.imageDirectory = tmp[0];
        if (!this.imageDirectory.exists()) {
            UIUtil.showErrorDialog(this, "Directory " + this.imageDirectory + " does not exist.");
            throw new RuntimeException();
        }
        this.imageTypeName = this.imageTypeNameTextField.getText().trim();
        this.metadataNameToValueToFiles = new TreeMap<String, Map<Comparable, List<File>>>(String.CASE_INSENSITIVE_ORDER);
        if (!this.userSuppliedRegex) {
            String[] fields = this.addMetadataPanel.getFields();
            this.metadataSeparatorChar = ((Character)this.fileNameMetadataSeparatorCharComboBox.getSelectedItem()).charValue();
            StringBuilder regexBuf = new StringBuilder();
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    regexBuf.append(this.metadataSeparatorChar);
                }
                regexBuf.append("(.*)");
            }
            this.regex = regexBuf.toString();
            this.pattern = Pattern.compile(this.regex);
            this.patternGroupNames = new ArrayList<String>(Arrays.asList(fields));
        } else {
            this.regex = this.regularExpressionTextField.getText().trim();
            this.pattern = Pattern.compile(NAMED_GROUP_PATTERN.matcher(this.regex).replaceAll("("));
            this.patternGroupNames = ImageTypePanel.getGroupNames(this.regex);
        }
        this.patternGroupNameToIndex = new HashMap();
        int size = this.patternGroupNames.size();
        for (int i = 0; i < size; ++i) {
            String group = this.patternGroupNames.get(i);
            this.metadataNameToValueToFiles.put(group, new HashMap());
            this.patternGroupNameToIndex.put(group, i);
        }
    }

    private String getFileName(File file) {
        String name = IOUtil.getBaseFileName(file);
        return name;
    }

    private void setUserSuppliedRegexVisibility() {
        this.regularExpressionTextField.setVisible(this.userSuppliedRegex);
        this.regularExpressionLabel.setVisible(this.userSuppliedRegex);
        this.addMetadataPanel.setVisible(!this.userSuppliedRegex);
        this.characterSeparatorLabel.setVisible(!this.userSuppliedRegex);
        this.fileNameMetadataSeparatorCharComboBox.setVisible(!this.userSuppliedRegex);
    }

    public static List<String> getGroupNames(String pattern) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(pattern);
        while (matcher.find()) {
            groupNames.add(matcher.group(1));
        }
        return groupNames;
    }

    public static class ImageFileFilter
    implements FileFilter {
        private String containsText;

        public ImageFileFilter(String text) {
            this.containsText = text = text.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            if ((name = name.toLowerCase()).contains("-thumb")) {
                return false;
            }
            if (name.contains(this.containsText)) {
                for (String imageExtension : IMAGE_EXTENSIONS) {
                    if (!name.endsWith(imageExtension)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

