/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.compound.painter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.chart.MatrixElement;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.ElementEvent;
import org.broadinstitute.genee.heatmap.ElementSelectionListener;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class ImageZoomWindow
implements GENEEWindowNotifier {
    private ElementSelectionListener heatMapElementListener;
    private ImagePanel imagePanel;
    private Project project;
    private List<MatrixElement> selectedElements = Collections.emptyList();
    private List<File> selectedFiles = new ArrayList<File>();
    private GENEEWindow window;
    private JSplitPane splitPane;

    public ImageZoomWindow(HeatMapPanel heatMapPanel) {
        this.project = heatMapPanel.getProject();
        this.heatMapElementListener = new ElementSelectionListener(){

            @Override
            public void elementSelectionChanged(ElementEvent e) {
                ImageZoomWindow.this.selectedElements = e.getSelectedElements();
                ImageZoomWindow.this.createWindow();
                ImageZoomWindow.this.updateForm();
                ImageZoomWindow.this.window.setVisible(true);
            }
        };
        this.project.getElementSelectionModel().addElementSelectionListener(this.heatMapElementListener);
        this.imagePanel = new ImagePanel();
    }

    private void createWindow() {
        if (this.window == null || !this.window.isVisible()) {
            this.window = Application.createViewWindow("Image Viewer", this);
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBottomComponent(UIUtil.createNoBorderScrollPane(this.imagePanel));
            this.splitPane.setDividerLocation(300);
            this.window.getContentPane().add(this.splitPane);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.window.setSize(screenSize.width - 40, screenSize.height - 60);
        }
    }

    @Override
    public void notifyHidden() {
    }

    @Override
    public void notifyShowing() {
    }

    private void updateForm() {
        this.selectedFiles.clear();
        Dataset dataset = this.project.getOriginalDataset();
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Image:");
        int seriesIndex = DatasetUtil.getSeriesIndex(dataset, ImageElement.class);
        AbstractButton firstCheckBox = null;
        int count = 0;
        for (MatrixElement e : this.selectedElements) {
            int column;
            int row = e.getRow();
            ImageElement element = (ImageElement)dataset.getObjectValue(row, column = e.getColumn(), seriesIndex);
            if (element == null) {
                return;
            }
            List<Collection<File>> fileList = element.getFiles();
            for (int i = 0; i < fileList.size(); ++i) {
                Collection<File> files = fileList.get(i);
                for (final File file : files) {
                    final JCheckBox cb = new JCheckBox(file.getName(), false);
                    ++count;
                    if (firstCheckBox == null) {
                        firstCheckBox = cb;
                    }
                    formBuilder.nextRow();
                    formBuilder.addFirstColumn(cb);
                    cb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (cb.isSelected()) {
                                ImageZoomWindow.this.selectedFiles.add(file);
                            } else {
                                ImageZoomWindow.this.selectedFiles.remove(file);
                            }
                            ImageZoomWindow.this.imagePanel.revalidate();
                            ImageZoomWindow.this.imagePanel.repaint();
                        }
                    });
                }
            }
        }
        if (count == 1) {
            firstCheckBox.doClick();
        }
        JScrollPane sp = UIUtil.createNoBorderScrollPane(formBuilder.getPanel());
        this.splitPane.setTopComponent(sp);
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    private class ImagePanel
    extends JPanel {
        @Override
        public Dimension getPreferredSize() {
            if (ImageZoomWindow.this.selectedFiles.size() == 0) {
                return new Dimension(0, 0);
            }
            Rectangle rect = this.getVisibleRect();
            return new Dimension(rect.width, rect.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i;
            super.paintComponent(g);
            if (ImageZoomWindow.this.selectedFiles.size() == 0) {
                return;
            }
            g.setColor(Color.BLACK);
            Rectangle rect = this.getVisibleRect();
            int rows = (int)Math.ceil((double)ImageZoomWindow.this.selectedFiles.size() / 2.0);
            int maxImageHeight = rect.height / rows;
            int maxImageWidth = rect.width;
            if (ImageZoomWindow.this.selectedFiles.size() > 1) {
                maxImageWidth /= 2;
            }
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            int width = Integer.MAX_VALUE;
            int height = Integer.MAX_VALUE;
            int size = ImageZoomWindow.this.selectedFiles.size();
            for (i = 0; i < size; ++i) {
                File file = (File)ImageZoomWindow.this.selectedFiles.get(i);
                BufferedImage image = ImageUtil.readImage(file);
                images.add(image);
                float aspectRatio = Math.min((float)maxImageWidth / (float)image.getWidth(), (float)maxImageHeight / (float)image.getHeight());
                int w = (int)((float)image.getWidth() * aspectRatio);
                int h = (int)((float)image.getHeight() * aspectRatio);
                width = Math.min(w, width);
                height = Math.min(h, height);
            }
            size = ImageZoomWindow.this.selectedFiles.size();
            for (i = 0; i < size; ++i) {
                BufferedImage image = (BufferedImage)images.get(i);
                int x = i % 2 == 0 ? 0 : width;
                int y = i / 2 * height;
                g.drawImage(image, x, y, width, height, null);
            }
        }
    }
}

