/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.examples;

import java.awt.Color;
import java.io.File;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.GeneeToolRunner;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ImageUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Vector;

public class HeatMapImageExample {
    public static void main(String[] args) throws Exception {
        System.setProperty("java.awt.headless", "true");
        UIUtil.standaloneInit();
        Project inputProject = ProjectIO.readProject("test/test_files/all_aml_train.neighbors.gct");
        Dataset dataset = inputProject.getOriginalDataset();
        Vector phenotypeVector = dataset.getColumnMetadata().add("Phenotype", String.class);
        int cols = dataset.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            phenotypeVector.setValue(j, ((String)dataset.getColumnMetadata().get(0).getValue(j)).startsWith("AML") ? "AML" : "ALL");
        }
        phenotypeVector.setProperty("Color Visible", true);
        phenotypeVector.setProperty("Text Visible", false);
        dataset = DatasetUtil.sliceView(dataset, IOUtil.seqInt(50), null);
        Project project = GeneeToolRunner.execute("Hierarchical Clustering", dataset, new BasicMapEntry<String>("Cluster rows", "true"))[0];
        VectorColorModel colorModel = project.getColumnColorModel();
        Vector phenotype = dataset.getColumnMetadata().get(dataset.getColumnMetadata().getColumnIndex("Phenotype"));
        colorModel.setMappedValue(phenotype, "AML", Color.YELLOW);
        colorModel.setMappedValue(phenotype, "ALL", Color.GREEN);
        HeatMapPanel heatMapPanel = new HeatMapPanel(project);
        heatMapPanel.setColumnColorCategoryLegendBoxSize(30);
        ImageUtil.saveImage(heatMapPanel, "jpeg", new File("test.jpeg"), true);
    }
}

