/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import org.broadinstitute.genee.filter.CheckBoxSelectorComponent;
import org.broadinstitute.genee.filter.FilterUI;
import org.broadinstitute.genee.filter.IndexedFilter;
import org.broadinstitute.genee.filter.SetIndexedFilter;

public class CheckBoxListFilterUI<T>
implements FilterUI {
    protected String filterName;
    protected Set selectedValuesSet;
    protected CheckBoxSelectorComponent filterSelectionComponent;

    public CheckBoxListFilterUI(String filterName, Collection values) {
        this.filterName = filterName;
        this.init(values);
    }

    @Override
    public IndexedFilter apply() {
        this.filterSelectionComponent.saveState();
        this.selectedValuesSet = this.filterSelectionComponent.getSelectedItems();
        return new SetIndexedFilter(this.selectedValuesSet);
    }

    @Override
    public void cancel() {
        this.filterSelectionComponent.restoreState();
    }

    @Override
    public String getFilterName() {
        return this.filterName;
    }

    public CheckBoxSelectorComponent getFilterSelectionComponent() {
        return this.filterSelectionComponent;
    }

    @Override
    public Component getUserInterfaceComponent() {
        return this.filterSelectionComponent.getComponent();
    }

    private void init(Collection values) {
        this.filterSelectionComponent = new CheckBoxSelectorComponent(values);
        this.selectedValuesSet = this.filterSelectionComponent.getSelectedItems();
    }
}

