/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.gui.DelimListDataIntelliHints;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.GENEEDefaultListCellRenderer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.LuceneSearchParser;
import org.broadinstitute.genee.heatmap.QuickListFilter;

public class CheckBoxSelectorComponent {
    private CheckBoxList checkBoxList;
    private boolean exclude = false;
    private JCheckBox excludeCheckBox;
    private boolean excludeSavedState;
    private FilterableListModel filterableListModel;
    private Collection items;
    private JPanel mainPanel;
    private int numberOfItems;
    private QuickListFilter quickFilter;
    private String savedFilterText = "";
    private JPanel selectFromListPanel;
    private JLabel selectionLabel;
    private Set selectedItems = new HashSet();

    public CheckBoxSelectorComponent(Collection values) {
        this.items = values;
        this.numberOfItems = this.items.size();
        this.filterableListModel = new FilterableListModel();
        if (this.items != null) {
            this.filterableListModel.setItems(this.items);
        }
        this.checkBoxList = new CheckBoxList((ListModel)((Object)this.filterableListModel));
        this.checkBoxList.setCellRenderer((ListCellRenderer)new GENEEDefaultListCellRenderer());
        this.checkBoxList.selectNone();
        this.selectionLabel = new JLabel(" ");
        if (this.items.size() > 20) {
            this.checkBoxList.setVisibleRowCount(Math.min(20, this.items.size()));
        }
        JButton selectAllButton = new JButton("All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxSelectorComponent.this.checkBoxList.selectAll();
            }
        });
        JButton selectNoneButton = new JButton("None");
        selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxSelectorComponent.this.checkBoxList.selectNone();
            }
        });
        JPanel buttonPanel = ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{selectAllButton, selectNoneButton});
        this.quickFilter = new QuickListFilter((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), this.filterableListModel){

            @Override
            protected String getSavedSearchKey() {
                return null;
            }
        };
        new DelimListDataIntelliHints(this.quickFilter.getTextField()){

            @Override
            public Collection<String> getMatches(String text) {
                boolean caseSensitive = this.isCaseSensitive();
                ArrayList<String> matches = new ArrayList<String>();
                for (Object val : CheckBoxSelectorComponent.this.items) {
                    String s;
                    String _val = s = val.toString();
                    if (!caseSensitive) {
                        _val = _val.toLowerCase();
                    }
                    if (!_val.startsWith(text)) continue;
                    matches.add(s);
                }
                Collections.sort(matches);
                return matches;
            }
        };
        this.selectFromListPanel = new JPanel(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        this.checkBoxList.setBackground(this.selectFromListPanel.getBackground());
        this.selectFromListPanel.add((Component)this.quickFilter.getComponent(), "North");
        this.selectFromListPanel.add((Component)UIUtil.createNoBorderScrollPane((Component)this.checkBoxList), "Center");
        JPanel lowerPanel = new JPanel((LayoutManager)new FormLayout("p", "p, 4px, p, 4px, p"));
        lowerPanel.add((Component)buttonPanel, cc.xy(1, 1));
        lowerPanel.add((Component)this.selectionLabel, cc.xy(1, 3));
        this.excludeCheckBox = new JCheckBox("Exclude selection", false);
        lowerPanel.add((Component)this.excludeCheckBox, cc.xy(1, 5));
        this.excludeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckBoxSelectorComponent.this.setExclude(CheckBoxSelectorComponent.this.excludeCheckBox.isSelected());
            }
        });
        this.checkBoxList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CheckBoxSelectorComponent.this.updateSelectionLabel();
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.nextRow();
        formBuilder.addLabel("Values:");
        formBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)formBuilder.getPanel(), "North");
        this.mainPanel.add((Component)this.selectFromListPanel, "Center");
        lowerPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        this.mainPanel.add((Component)lowerPanel, "South");
        this.updateSelectionLabel();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.checkBoxList.getCheckBoxListSelectionModel().addListSelectionListener(l);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public LuceneSearchParser.IndexedSearchPredicate getSearchPredicate() {
        return this.quickFilter.getSearchPredicate();
    }

    public Set getSelectedItems() {
        return this.selectedItems;
    }

    public void restoreState() {
        this.exclude = this.excludeSavedState;
        this.excludeCheckBox.setSelected(this.exclude);
        this.quickFilter.setSearchText(this.savedFilterText);
        this.checkBoxList.setSelectedObjects(this.selectedItems.toArray());
    }

    public void saveState() {
        this.selectedItems = this.exclude ? UIUtil.getUnselectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel)) : UIUtil.getSelectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel));
        this.excludeSavedState = this.exclude;
        this.savedFilterText = this.quickFilter.getTextField().getText();
    }

    public Set getSelection() {
        return this.exclude ? UIUtil.getUnselectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel)) : UIUtil.getSelectedValues((ListSelectionModel)this.checkBoxList.getCheckBoxListSelectionModel(), (ListModel)((Object)this.filterableListModel));
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
        this.updateSelectionLabel();
    }

    public void setSelectedItems(Collection items) {
        this.excludeCheckBox.setSelected(false);
        this.checkBoxList.getCheckBoxListSelectionModel().setValueIsAdjusting(true);
        this.quickFilter.setSearchText("");
        HashMap<Object, Integer> valueToIndex = new HashMap<Object, Integer>();
        int cc = this.filterableListModel.getSize();
        for (int i = 0; i < cc; ++i) {
            valueToIndex.put(this.filterableListModel.getElementAt(i), i);
        }
        for (Object item : items) {
            Integer index = (Integer)valueToIndex.get(item);
            if (index == null) continue;
            this.checkBoxList.getCheckBoxListSelectionModel().addSelectionInterval(index.intValue(), index.intValue());
        }
        this.checkBoxList.getCheckBoxListSelectionModel().setValueIsAdjusting(false);
    }

    private void updateSelectionLabel() {
        this.selectionLabel.setText((this.exclude ? "Excluded " : "Selected ") + this.checkBoxList.getCheckBoxListSelectedIndices().length + " out of " + this.numberOfItems + " values");
    }
}

