/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.filter.FilterPanel;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class FilterRowsAction
extends AbstractAction {
    private GENEEWindow window;
    private FilterPanel filterPanel;
    private HeatMapPanel heatMapPanel;

    public FilterRowsAction(HeatMapPanel heatMapPanel) {
        super("Filter Rows\u2026");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/20455.sc_datafilterstandardfilter.png"));
        this.putValue("ShortDescription", "Filter rows");
        this.heatMapPanel = heatMapPanel;
    }

    private void showWindow() {
        if (this.window == null) {
            this.window = Application.createDialog("Filter Rows");
            Project project = this.heatMapPanel.getProject();
            this.filterPanel = new FilterPanel(project);
            this.window.getContentPane().setLayout((LayoutManager)new JideBoxLayout(this.window.getContentPane(), 1));
            this.window.getContentPane().add(this.filterPanel.getNorth(), "fix");
            this.window.getContentPane().add((Component)new JScrollPane(this.filterPanel.getCenter()), "flexible");
            this.window.getContentPane().add(this.filterPanel.getSouth(), "fix");
            this.window.pack();
            this.window.setSize(Math.max(500, this.window.getWidth()), Math.max(600, this.window.getHeight()));
        } else {
            this.filterPanel.rebuild();
        }
        this.window.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        this.showWindow();
    }
}

