/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.filter;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;

public class RangeSlider
extends JPanel {
    private CoordinateMapper coordinateMapper;
    private Color highlightColor = UIManager.getColor("Slider.highlight");
    private float maxOffset = -1.0f;
    private Shape maxThumb;
    private float maxValue;
    private float minOffset = -1.0f;
    private Shape minThumb;
    private float minValue;
    private Color shadowColor = UIManager.getColor("Slider.shadow");
    private int trackHeight = 6;
    private boolean dragging;

    public RangeSlider(float min, float max) {
        this.coordinateMapper = new WorldCoordinateMapper();
        this.coordinateMapper.setLeftGutter(0.0f);
        this.coordinateMapper.setRightGutter(0.0f);
        this.coordinateMapper.setXMin(min);
        this.coordinateMapper.setXMax(max);
        this.minValue = min;
        this.maxValue = max;
        this.coordinateMapper.setClipX(true);
        this.setPreferredSize(new Dimension(300, 40));
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                float max;
                RangeSlider.this.dragging = true;
                if (RangeSlider.this.minOffset != -1.0f) {
                    float min = RangeSlider.this.coordinateMapper.pixToX(e.getX());
                    if (min <= RangeSlider.this.maxValue) {
                        RangeSlider.this.setMinValue(min);
                    }
                } else if (RangeSlider.this.maxOffset != -1.0f && (max = RangeSlider.this.coordinateMapper.pixToX(e.getX())) >= RangeSlider.this.minValue) {
                    RangeSlider.this.setMaxValue(max);
                }
                RangeSlider.this.dragging = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (RangeSlider.this.minThumb.contains(e.getPoint())) {
                    RangeSlider.this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (RangeSlider.this.maxThumb.contains(e.getPoint())) {
                    RangeSlider.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    RangeSlider.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RangeSlider.this.minOffset = -1.0f;
                RangeSlider.this.maxOffset = -1.0f;
                if (RangeSlider.this.minThumb.contains(e.getPoint())) {
                    RangeSlider.this.minOffset = RangeSlider.this.coordinateMapper.xToPix(RangeSlider.this.minValue) - (float)e.getX();
                } else if (RangeSlider.this.maxThumb.contains(e.getPoint())) {
                    RangeSlider.this.maxOffset = RangeSlider.this.coordinateMapper.xToPix(RangeSlider.this.maxValue) - (float)e.getX();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RangeSlider.this.isMinGreaterThanMax()) {
                    float tmp = RangeSlider.this.minValue;
                    RangeSlider.this.setMinValue(RangeSlider.this.maxValue);
                    RangeSlider.this.setMaxValue(tmp);
                }
                RangeSlider.this.minOffset = -1.0f;
                RangeSlider.this.maxOffset = -1.0f;
                RangeSlider.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public boolean isMinGreaterThanMax() {
        return this.minValue > this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        float old = this.maxValue;
        this.maxValue = maxValue;
        this.repaint();
        this.firePropertyChange("maxValue", old, maxValue);
    }

    public void setMinValue(float minValue) {
        float old = this.minValue;
        this.minValue = minValue;
        this.repaint();
        this.firePropertyChange("minValue", old, minValue);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int thumbWidth = 8;
        int gutter = thumbWidth + 6;
        int cw = this.getWidth() - gutter * 2;
        this.coordinateMapper.setLeftGutter(gutter);
        this.coordinateMapper.setRightGutter(gutter);
        this.coordinateMapper.setXPixelScale(this.getWidth());
        int fontHeight = g.getFontMetrics().getHeight();
        int yTop = this.getHeight() - 4 - this.trackHeight - fontHeight;
        g.translate(gutter, yTop);
        g.setColor(this.shadowColor);
        g.drawLine(0, 0, cw - 1, 0);
        g.drawLine(0, 1, 0, 2);
        g.setColor(this.highlightColor);
        g.drawLine(0, 3, cw, 3);
        g.drawLine(cw, 0, cw, 3);
        g.setColor(Color.BLACK);
        g.drawLine(1, 1, cw - 2, 1);
        float minPix = this.coordinateMapper.xToPix(this.minValue);
        float maxPix = this.coordinateMapper.xToPix(this.maxValue);
        g.setColor(Color.DARK_GRAY);
        Graphics2D g2 = (Graphics2D)g;
        g.translate(-gutter, -yTop);
        g2.fill(new Rectangle2D.Float(minPix, yTop, maxPix - minPix, this.trackHeight));
        g.setColor(Color.BLACK);
        String minString = Formatter.format(this.coordinateMapper.getXMin());
        String maxString = Formatter.format(this.coordinateMapper.getXMax());
        g.drawString(minString, (int)this.coordinateMapper.xToPix(this.coordinateMapper.getXMin()), yTop + this.trackHeight + fontHeight);
        g.drawString(maxString, gutter + cw - g.getFontMetrics().stringWidth(maxString), yTop + this.trackHeight + fontHeight);
        this.minThumb = this.drawThumb(g2, minPix - (float)thumbWidth, yTop - 2, thumbWidth);
        this.maxThumb = this.drawThumb(g2, maxPix, yTop - 2, thumbWidth);
    }

    private Shape drawThumb(Graphics2D g2, float x, float y, int width) {
        Ellipse2D.Float thumbShape = new Ellipse2D.Float(x, y, width, this.trackHeight + 2);
        g2.setColor(this.highlightColor);
        g2.fill(thumbShape);
        g2.setColor(Color.BLACK);
        g2.draw(thumbShape);
        return thumbShape;
    }

    public boolean isDragging() {
        return this.dragging;
    }
}

