/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import com.jidesoft.hints.ListDataIntelliHints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.gui.FTPFile;
import org.broadinstitute.genee.gui.FTPFileModel;
import org.broadinstitute.genee.gui.FilterableListModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.heatmap.QuickListFilter;
import org.broadinstitute.genee.io.util.IOUtil;

public class ChipFileInput
implements InputParameter<File> {
    private static final String CHIP_SPACER = "---------";
    private static FTPFile[] chipFiles;
    private JComboBox comboBox;
    private boolean initted = false;
    private JList list;
    private JPanel panel;
    private boolean useList;

    public ChipFileInput(boolean useList) {
        this.useList = useList;
        this.panel = new JPanel(new BorderLayout());
        if (useList) {
            FilterableListModel listModel = new FilterableListModel();
            this.list = new JList(listModel);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String s = value.toString();
                    return super.getListCellRendererComponent((JList<?>)list, IOUtil.getBaseFileName(s), index, isSelected, cellHasFocus);
                }
            });
            QuickListFilter filterField = new QuickListFilter(this.list.getSelectionModel(), listModel){

                @Override
                protected String getSavedSearchKey() {
                    return "chip.file";
                }
            };
            new ListDataIntelliHints((JTextComponent)filterField.getTextField(), new ArrayList<Object>(Arrays.asList(((DefaultListModel)listModel.getActualModel()).toArray())));
            this.list.setVisibleRowCount(30);
            this.list.setSelectionMode(0);
            this.panel.add(new JScrollPane(this.list));
            JPanel topPanel = new JPanel(new FlowLayout(0));
            topPanel.add((Component)((Object)filterField));
            this.panel.add((Component)topPanel, "North");
        } else {
            this.comboBox = UIUtil.createComboBox();
            this.comboBox.setEditable(false);
            this.comboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String s = value.toString();
                    return super.getListCellRendererComponent((JList<?>)list, IOUtil.getBaseFileName(s), index, isSelected, cellHasFocus);
                }
            });
            this.panel.add((Component)this.comboBox, "Center");
        }
    }

    @Override
    public JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public File getParameterValue() {
        FTPFile ftpFile;
        FTPFile fTPFile = ftpFile = this.useList ? (FTPFile)this.list.getSelectedValue() : (FTPFile)this.comboBox.getSelectedItem();
        if (ftpFile.getName().equals(CHIP_SPACER)) {
            return null;
        }
        try {
            File tmpFile = File.createTempFile("tmp", ".chip");
            tmpFile.deleteOnExit();
            FTPFileModel.chipFileDownload(tmpFile, ftpFile.getName());
            return tmpFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to download " + ftpFile.getName() + ".");
        }
    }

    @Override
    public Class<?> getValueClass() {
        return File.class;
    }

    public void init() {
        ChipFileInput.createChipFiles();
        if (!this.initted) {
            if (this.useList) {
                ((FilterableListModel)((Object)this.list.getModel())).setItems(new ArrayList<FTPFile>(Arrays.asList(chipFiles)));
            } else {
                this.comboBox.removeAllItems();
                for (FTPFile f : chipFiles) {
                    this.comboBox.addItem(f);
                }
            }
            this.setValueFromString("GENE_SYMBOL");
            this.initted = true;
        }
    }

    @Override
    public void init(Object value) {
    }

    @Override
    public void setValueFromString(String s) {
        for (FTPFile f : chipFiles) {
            if (!f.getName().startsWith(s)) continue;
            if (this.useList) {
                this.list.setSelectedValue(f, false);
                break;
            }
            this.comboBox.setSelectedItem(f);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createChipFiles() {
        if (chipFiles != null) {
            return;
        }
        FTPFileModel model = null;
        try {
            int i;
            model = FTPFileModel.createChipInstance();
            String[] fileNames = model.getFileNames();
            Arrays.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
            LinkedList<String> list = new LinkedList<String>(Arrays.asList(fileNames));
            String[] fru = new String[]{"GENE_SYMBOL.chip", "HG_U133A.chip", "HG_U133A_2.chip", "HG_U133_Plus_2.chip"};
            list.add(0, CHIP_SPACER);
            for (i = fru.length - 1; i >= 0; --i) {
                if (!list.contains(fru[i])) continue;
                list.add(0, fru[i]);
            }
            chipFiles = new FTPFile[list.size()];
            int length = list.size();
            for (i = 0; i < length; ++i) {
                ChipFileInput.chipFiles[i] = new FTPFile(model.getHost(), model.getDir(), (String)list.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (model != null) {
                    model.quit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

