/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetIO;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetPair;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetPair;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GeneSetMatrixParameterInput
implements InputParameter<Collection<? extends GeneSetPair>> {
    private MSigDBSetBrowser browser = new MSigDBSetBrowser();
    private JTextArea selectedFilesTextArea;
    private JTabbedPane tabbedPane = new JTabbedPane();

    public GeneSetMatrixParameterInput() {
        this.tabbedPane.addTab("MSigDB Website", this.browser.scrollPane);
        JButton browseButton = new JButton("Browse\u2026");
        this.selectedFilesTextArea = new JTextArea(10, 20);
        UIUtil.setLabelProperties(this.selectedFilesTextArea);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] files = FileChooserUtil.showMultiSelectOpenDialog(GeneSetMatrixParameterInput.this.tabbedPane, "GMX/GMT File(s)");
                if (files != null) {
                    GeneSetMatrixParameterInput.this.selectedFilesTextArea.setText(ToStringUtil.toString(files, "\n"));
                }
            }
        });
        CellConstraints cc = new CellConstraints();
        JPanel tmp = new JPanel(new FlowLayout(3));
        tmp.add(browseButton);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)tmp, "North");
        JPanel localFilesPanel = new JPanel((LayoutManager)new FormLayout("p:g", "p:g, 6px, p:g"));
        localFilesPanel.add((Component)UIUtil.createNoBorderScrollPane(this.selectedFilesTextArea), cc.xy(1, 3));
        p.add(localFilesPanel);
        this.tabbedPane.addTab("Local GMT/GMX Files", p);
    }

    @Override
    public JComponent getJComponent() {
        return this.tabbedPane;
    }

    @Override
    public Collection<? extends GeneSetPair> getParameterValue() {
        List<String> files;
        int tabIndex = this.tabbedPane.getSelectedIndex();
        if (tabIndex == 0) {
            try {
                files = this.browser.getSelection();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to download gene sets from MSigDB");
            }
        } else {
            String[] text = this.selectedFilesTextArea.getText().trim().split("\n");
            files = new ArrayList<String>();
            for (String token : text) {
                if ((token = token.trim()).equals("")) continue;
                files.add(token);
            }
        }
        HashMap<String, DefaultGeneSetPair> nameToGeneSetPair = new HashMap<String, DefaultGeneSetPair>();
        for (String file : files) {
            try {
                GeneSetMatrix m = GeneSetIO.readGeneSetMatrix(file);
                int n = m.getNumGeneSets();
                for (int i = 0; i < n; ++i) {
                    GeneSet set = m.get(i);
                    String name = set.getName();
                    String lc = name.toLowerCase();
                    String baseName = null;
                    boolean down = false;
                    if (lc.endsWith("_dn")) {
                        baseName = name.substring(0, name.length() - "_dn".length());
                        down = true;
                    } else if (lc.endsWith("_up")) {
                        baseName = name.substring(0, name.length() - "_up".length());
                    } else if (lc.endsWith("_down")) {
                        baseName = name.substring(0, name.length() - "_down".length());
                        down = true;
                    }
                    if (baseName == null) continue;
                    DefaultGeneSetPair pair = (DefaultGeneSetPair)nameToGeneSetPair.get(baseName);
                    if (pair == null) {
                        pair = new DefaultGeneSetPair(baseName, null, null);
                        nameToGeneSetPair.put(baseName, pair);
                    }
                    if (down) {
                        pair.setDown(set);
                        continue;
                    }
                    pair.setUp(set);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading " + IOUtil.getName(file));
            }
        }
        return nameToGeneSetPair.values();
    }

    @Override
    public Class<?> getValueClass() {
        return Collection.class;
    }

    @Override
    public void init(Object value) {
    }

    @Override
    public void setValueFromString(String s) {
        String[] tokens = s.split("\n");
        StringBuilder files = new StringBuilder();
        for (String token : tokens) {
            if (files.length() > 0) {
                files.append("\n");
            }
            files.append(token);
        }
        if (files.length() > 0) {
            this.selectedFilesTextArea.setText(files.toString());
        }
    }

    private static class MSigDBSetBrowser {
        private FTPClient ftp = new FTPClient();
        private JList list;
        private JScrollPane scrollPane;

        private MSigDBSetBrowser() {
            try {
                this.ftp.setRemoteHost("gseaftp.broadinstitute.org");
                this.ftp.connect();
                this.ftp.login("gs3as3cr3tz", "asdf7hEGw");
                this.ftp.setType(FTPTransferType.BINARY);
                this.ftp.chdir("/pub/gsea/gene_sets");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.list = new JList(new DefaultListModel());
            this.scrollPane = new JScrollPane(this.list);
            this.refresh();
        }

        public List<String> getSelection() throws Exception {
            Object[] selection = this.list.getSelectedValues();
            ArrayList<String> list = new ArrayList<String>();
            if (selection != null) {
                for (Object sel : selection) {
                    String name = (String)sel;
                    File dest = File.createTempFile(name, IOUtil.getExtension(name));
                    this.ftp.get(dest.getCanonicalPath(), name);
                    list.add(dest.getCanonicalPath());
                }
            }
            return list;
        }

        private void refresh() {
            try {
                String[] filenames = this.ftp.dir();
                String version = new String(this.ftp.get(".version")).trim();
                final ArrayList<String> names = new ArrayList<String>();
                if (filenames != null) {
                    for (String name : filenames) {
                        if (!name.contains(version)) continue;
                        names.add(name);
                    }
                    Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
                }
                this.list.setModel(new AbstractListModel(){

                    @Override
                    public Object getElementAt(int i) {
                        return names.get(i);
                    }

                    @Override
                    public int getSize() {
                        return names.size();
                    }
                });
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

