/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gsea;

import org.broadinstitute.genee.gsea.KSElement;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.ShortList;

public class Gsea {
    private float p;

    public Gsea(float p) {
        this.p = p;
    }

    public float execute(float N, ShortList ranks, FloatList scores) {
        float runningScore;
        int Nh = ranks.size();
        float Nr = 0.0f;
        for (int i = 0; i < Nh; ++i) {
            Nr = (float)((double)Nr + Math.pow(Math.abs(scores.getValue(i)), this.p));
        }
        float Pmiss = 1.0f / (N - (float)Nh);
        float max = runningScore = 0.0f;
        float absMax = Math.abs(max);
        for (int i = 0; i < Nh; ++i) {
            float absScore;
            short rank = ranks.getValue(i);
            float corr = scores.getValue(i);
            float hit = (float)(Math.pow(Math.abs(corr), this.p) / (double)Nr);
            float delta = (float)(rank - (i == 0 ? (short)0 : ranks.getValue(i - 1))) - 1.0f;
            float cumMiss = Pmiss * delta;
            if ((runningScore -= cumMiss) <= 0.0f && (absScore = Math.abs(runningScore)) > absMax) {
                max = runningScore;
                absMax = absScore;
            }
            if (!((absScore = Math.abs(runningScore += hit)) > absMax)) continue;
            max = runningScore;
            absMax = absScore;
        }
        return max;
    }

    public KSElement[] runningScore(float N, ShortList ranks, FloatList scores) {
        float runningScore;
        int Nh = ranks.size();
        float Nr = 0.0f;
        for (int i = 0; i < Nh; ++i) {
            Nr = (float)((double)Nr + Math.pow(Math.abs(scores.getValue(i)), this.p));
        }
        float Pmiss = 1.0f / (N - (float)Nh);
        float max = runningScore = 0.0f;
        float absMax = Math.abs(max);
        KSElement[] runningScoreArray = new KSElement[Nh + 2];
        runningScoreArray[0] = new KSElement(Float.NaN, 0, 0.0f);
        for (int i = 0; i < Nh; ++i) {
            boolean isNegative;
            short rank = ranks.getValue(i);
            float corr = scores.getValue(i);
            float hit = (float)(Math.pow(Math.abs(corr), this.p) / (double)Nr);
            float delta = (float)(rank - (i == 0 ? (short)1 : ranks.getValue(i - 1))) - 1.0f;
            float cumMiss = Pmiss * delta;
            float absScore1 = 0.0f;
            float beforeHitCost = 0.0f;
            boolean bl = isNegative = (runningScore -= cumMiss) <= 0.0f;
            if (isNegative) {
                absScore1 = Math.abs(runningScore);
                if (absScore1 > absMax) {
                    max = runningScore;
                    absMax = absScore1;
                }
                beforeHitCost = runningScore;
            }
            float absScore2 = Math.abs(runningScore += hit);
            if (!isNegative) {
                absScore1 = absScore2;
                beforeHitCost = runningScore;
            }
            if (absScore2 > absMax) {
                max = runningScore;
                absMax = absScore2;
            }
            runningScoreArray[i + 1] = new KSElement(corr, rank, absScore1 > absScore2 ? beforeHitCost : runningScore);
        }
        runningScoreArray[runningScoreArray.length - 1] = new KSElement(Float.NaN, (int)N, runningScore - Pmiss * (N - (float)ranks.getValue(ranks.size() - 1) - 1.0f));
        return runningScoreArray;
    }

    public static float combineUpAndDownScores(float upScore, float dnScore) {
        if (upScore > 0.0f && dnScore < 0.0f || upScore < 0.0f && dnScore > 0.0f) {
            return (upScore - dnScore) / 2.0f;
        }
        return 0.0f;
    }
}

