/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.IconManager;

public abstract class AddRemoveComponentList {
    private String baseName;
    private CollapsiblePanes collapsiblePanes;

    public AddRemoveComponentList(String baseName) {
        this.baseName = baseName;
        this.collapsiblePanes = new CollapsiblePanes();
        this.collapsiblePanes.setGap(0);
        this.collapsiblePanes.setBackground(UIManager.getColor("Panel.background"));
        this.collapsiblePanes.addExpansion();
        if (!GraphicsEnvironment.isHeadless()) {
            this.collapsiblePanes.add((Component)((Object)new MyCollapsiblePane()));
        }
    }

    public List<JComponent> getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            components.add((JComponent)c);
        }
        return components;
    }

    protected abstract JComponent createComponent();

    protected void notifyAdded() {
    }

    private void setIndices() {
        MyCollapsiblePane p = null;
        int index = 0;
        int cc = this.collapsiblePanes.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            Component c = this.collapsiblePanes.getComponent(i);
            if (!(c instanceof MyCollapsiblePane)) continue;
            ((MyCollapsiblePane)((Object)c)).setIndex(index++);
            if (index != 1) continue;
            p = (MyCollapsiblePane)((Object)c);
        }
        if (index > 1) {
            p.setEnableDelete(true);
        }
    }

    private class MyCollapsiblePane
    extends CollapsiblePane {
        private JButton addButton;
        private JComponent c;
        private JButton deleteButton;

        private MyCollapsiblePane() {
            super("");
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.setOpaque(false);
            this.deleteButton = new JButton(IconManager.loadIcon("16x16/14763.delete.gif"));
            this.deleteButton.setToolTipText("Delete");
            this.deleteButton.setEnabled(false);
            this.addButton = new JButton(IconManager.loadIcon("16x16/10551.add_exc.gif"));
            this.addButton.setToolTipText("Add");
            ActionListener addActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyCollapsiblePane pane = new MyCollapsiblePane();
                    AddRemoveComponentList.this.notifyAdded();
                    AddRemoveComponentList.this.collapsiblePanes.add((Component)((Object)pane));
                    AddRemoveComponentList.this.setIndices();
                    int cc = AddRemoveComponentList.this.collapsiblePanes.getComponentCount();
                    for (int i = 0; i < cc; ++i) {
                        Component c = AddRemoveComponentList.this.collapsiblePanes.getComponent(i);
                        if (!(c instanceof MyCollapsiblePane) || c == pane) continue;
                        try {
                            ((CollapsiblePane)c).setCollapsed(true);
                            continue;
                        }
                        catch (PropertyVetoException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            };
            this.addButton.addActionListener(addActionListener);
            ActionListener deleteActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddRemoveComponentList.this.collapsiblePanes.remove((Component)((Object)MyCollapsiblePane.this));
                    AddRemoveComponentList.this.collapsiblePanes.revalidate();
                    AddRemoveComponentList.this.setIndices();
                }
            };
            this.deleteButton.addActionListener(deleteActionListener);
            panel.add(this.addButton);
            panel.add(this.deleteButton);
            this.setTitleComponent(panel);
            this.setTitleLabelGap(0);
            this.setSteps(1);
            this.c = AddRemoveComponentList.this.createComponent();
            this.setContentPane(this.c);
        }

        public void setEnableDelete(boolean b) {
            this.deleteButton.setEnabled(b);
        }

        public void setIndex(int index) {
            this.setTitle(AddRemoveComponentList.this.baseName + " " + (index + 1));
            this.deleteButton.setEnabled(index > 0);
        }
    }
}

