/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.OverlayTextField;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BackgroundTextField {
    private JTextField inputField;
    private DefaultOverlayable overlayinputField;

    public BackgroundTextField(String backgroundText) {
        this(backgroundText, backgroundText.length());
    }

    public BackgroundTextField(String backgroundText, int columns) {
        this.inputField = new OverlayTextField("", columns);
        this.overlayinputField = new DefaultOverlayable((JComponent)this.inputField);
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (BackgroundTextField.this.inputField.getDocument().getLength() > 0) {
                    BackgroundTextField.this.overlayinputField.setOverlayVisible(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (BackgroundTextField.this.inputField.getDocument().getLength() == 0) {
                    BackgroundTextField.this.overlayinputField.setOverlayVisible(true);
                }
            }
        });
        this.inputField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BackgroundTextField.this.overlayinputField.setOverlayVisible(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                BackgroundTextField.this.overlayinputField.setOverlayVisible(BackgroundTextField.this.inputField.getDocument().getLength() == 0);
            }
        });
        this.overlayinputField.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)backgroundText), 7);
    }

    public JTextField getInputField() {
        return this.inputField;
    }

    public DefaultOverlayable getOverlayinputField() {
        return this.overlayinputField;
    }

    public void setOverlayVisible(boolean b) {
        this.overlayinputField.setOverlayVisible(b);
    }
}

