/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public final class BrowserLauncher {
    private static int jvm;
    private static final int WINDOWS = 1;
    private static final int MAC = 2;
    private static final int OTHER = 3;
    private static final int SPECIFIED = 4;
    private static String specifiedBrowser;

    private BrowserLauncher() {
    }

    public static void openURL(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.BROWSE)) {
                try {
                    d.browse(new URL(url).toURI());
                }
                catch (Exception exception) {}
            }
        } else {
            BrowserLauncher.tryToOpen(url);
        }
    }

    public static void openFile(File file) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.OPEN)) {
                try {
                    d.open(file);
                }
                catch (Exception exception) {}
            }
        } else {
            BrowserLauncher.tryToOpen(file.toURI().toString());
        }
    }

    private static void tryToOpen(String url) {
        try {
            switch (jvm) {
                case 2: {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", url});
                    break;
                }
                case 1: {
                    Process process = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    try {
                        process.waitFor();
                        process.exitValue();
                    }
                    catch (InterruptedException ie) {}
                    break;
                }
                case 3: {
                    if (new File("/usr/bin/gnome-open").exists()) {
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/gnome-open", url});
                        break;
                    }
                    if (new File("/usr/bin/kde-open").exists()) {
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/kde-open", url});
                        break;
                    }
                    String browser = null;
                    String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape", "epiphany"};
                    for (int count = 0; count < browsers.length && browser == null; ++count) {
                        try {
                            if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                            browser = browsers[count];
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (browser != null) {
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                    break;
                }
                case 4: {
                    Process process = Runtime.getRuntime().exec(new String[]{specifiedBrowser, url});
                    try {
                        process.waitFor();
                        process.exitValue();
                        break;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        String osName = System.getProperty("os.name");
        jvm = osName.startsWith("Mac OS") ? 2 : (osName.startsWith("Windows") ? 1 : 3);
    }
}

